% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_get_data.R
\name{sits_get_data.sf}
\alias{sits_get_data.sf}
\title{Get time series using sf objects}
\usage{
\method{sits_get_data}{sf}(
  cube,
  samples,
  ...,
  start_date = NULL,
  end_date = NULL,
  bands = NULL,
  impute_fn = impute_linear(),
  label = "NoClass",
  label_attr = NULL,
  n_sam_pol = 30L,
  pol_avg = FALSE,
  sampling_type = "random",
  multicores = 2L,
  progress = FALSE
)
}
\arguments{
\item{cube}{Data cube from where data is to be retrieved.
(tibble of class "raster_cube").}

\item{samples}{The name of a shapefile.}

\item{...}{Specific parameters for specific cases.}

\item{start_date}{Start of the interval for the time series - optional
(Date in "YYYY-MM-DD" format).}

\item{end_date}{End of the interval for the time series - optional
(Date in "YYYY-MM-DD" format).}

\item{bands}{Bands to be retrieved - optional
(character vector).}

\item{impute_fn}{Imputation function to remove NA.}

\item{label}{Label to be assigned to all time series - optional}

\item{label_attr}{Attribute in the sf object to be used
as a polygon label.}

\item{n_sam_pol}{Number of samples per polygon to be read
for POLYGON or MULTIPOLYGON objects.}

\item{pol_avg}{Logical: summarize samples for each polygon?}

\item{sampling_type}{Spatial sampling type: random, hexagonal,
regular, or Fibonacci.}

\item{multicores}{Number of threads to process the time series
(integer, with min = 1 and max = 2048).}

\item{progress}{Logical: show progress bar?}
}
\value{
A tibble of class "sits" with set of time series
<longitude, latitude, start_date, end_date, label>.
}
\description{
Retrieve a set of time series from a data cube and
and put the result in a "sits tibble", which
contains both the satellite image time series and their metadata.
The \code{samples} parameter must be a \code{sf} object
in POINT or POLYGON geometry.
If \code{start_date} and \code{end_date} are not informed, the function
uses these data from the cube.
}
\note{
#' For sf objects, the following parameters are relevant:
\itemize{
\item{\code{label}: label to be assigned to the samples.
Should only be used if all geometries have a single label.}
\item{\code{label_attr}: defines which attribute should be
used as a label, required for POINT and POLYGON geometries if
\code{label} has not been set.}
\item{\code{n_sam_pol}: indicates how many points are
extracted from each polygon, required for POLYGON geometry (default = 15).}
\item{\code{sampling_type}: defines how sampling is done, required
for POLYGON geometry (default = "random").}
\item{\code{pol_avg}: indicates if average of values for POLYGON
geometry should be computed (default = "FALSE").}
}
}
\examples{
if (sits_run_examples()) {
    # reading a shapefile from BDC (Brazil Data Cube)
    bdc_cube <- sits_cube(
        source = "BDC",
        collection = "CBERS-WFI-16D",
        bands = c("NDVI", "EVI"),
        tiles = c("007004", "007005"),
        start_date = "2018-09-01",
        end_date = "2018-10-28"
    )
    # define a shapefile to be read from the cube
    shp_file <- system.file("extdata/shapefiles/bdc-test/samples.shp",
        package = "sits"
    )
    # read a shapefile into an sf object
    sf_object <- sf::st_read(shp_file)
    # get samples from the BDC using an sf object
    time_series_bdc <- sits_get_data(
        cube = bdc_cube,
        samples = sf_object
    )
}
}
