% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{agrupar_area_geo}
\alias{agrupar_area_geo}
\title{Agrupar por área geográfica}
\usage{
agrupar_area_geo(data_event, col_area = "area", porcentaje = FALSE)
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de la
enfermedad o evento.}

\item{col_area}{Un `character` (cadena de caracteres) con el nombre de
la columna que contiene las áreas geográficas en los datos de la enfermedad
o evento; su valor por defecto es `"area"`.}

\item{porcentaje}{Un `logical` (TRUE o FALSE) que indica si se debe
agregar una columna con el porcentaje de casos; su valor por
defecto es `FALSE`.}
}
\value{
Un `data.frame` con los datos de la enfermedad o evento agrupados
por área geográfica.
}
\description{
Función que agrupa los datos de una enfermedad o evento por
área geográfica.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
agrupar_area_geo(
  data_event = data_limpia,
  col_area = "area",
  porcentaje = FALSE
)
}
