% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sju.strpos}
\alias{sju.strpos}
\title{Find partial matching and close distance elements in strings}
\usage{
sju.strpos(searchString, findTerm, maxdist = 3, part.dist.match = 0,
  showProgressBar = FALSE)
}
\arguments{
\item{searchString}{a character vector with string elements}

\item{findTerm}{the string that should be matched against the elements of \code{searchString}.}

\item{maxdist}{the maximum distance between two string elements, which is allowed to treat them
as similar or equal.}

\item{part.dist.match}{activates similar matching (close distance strings) for parts (substrings)
of the \code{searchString}. Following values are accepted:
\itemize{
  \item 0 for no partial distance matching
  \item 1 for one-step matching, which means, only substrings of same length as \code{findTerm} are extracted from \code{searchString} matching
  \item 2 for two-step matching, which means, substrings of same length as \code{findTerm} as well as strings with a slightly wider range are extracted from \code{searchString} matching
}
Default value is 0.}

\item{showProgressBar}{If \code{TRUE}, the progress bar is displayed when computing the distance matrix.
         Default in \code{FALSE}, hence the bar is hidden.}
}
\value{
A numeric vector with index position of elements in \code{searchString} that
          partially match or are similar to \code{findTerm}. Returns \code{-1} if no
          match was found.
}
\description{
This function finds the element indices of partial matching or similar strings
               in a character vector. Can be used to find exact or slightly mistyped elements
               in a string vector.
}
\note{
this function does \emph{not} return the position of a matching string \emph{inside}
        another string, but the element's index of the \code{searchString} vector, where
        a (partial) match with \code{findTerm} was found. Thus, searching for "abc" in
        a string "this is abc" will not return 9 (the start position of the substring),
        but 1 (the element index, which is always 1 if \code{searchString} only has one element).
}
\examples{
\dontrun{
string <- c("Hello", "Helo", "Hole", "Apple", "Ape", "New", "Old", "System", "Systemic")
sju.strpos(string, "hel")   # partial match
sju.strpos(string, "stem")  # partial match
sju.strpos(string, "R")     # no match
sju.strpos(string, "saste") # similarity to "System"

# finds two indices, because partial matching now
# also applies to "Systemic"
sju.strpos(string,
           "sytsme",
           part.dist.match = 1)

# finds nothing
sju.strpos("We are Sex Pistols!", "postils")
# finds partial matching of similarity
sju.strpos("We are Sex Pistols!", "postils", part.dist.match = 1)}
}
\seealso{
\code{\link{sju.groupString}}
}

