% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotGLME.R
\name{sjp.lmer}
\alias{sjp.lmer}
\title{Plot estimates or predicted values of linear mixed effects models}
\usage{
sjp.lmer(fit, type = "re", vars = NULL, ri.nr = NULL, emph.grp = NULL,
  title = NULL, geom.size = NULL, geom.colors = "Set1",
  hideErrorBars = FALSE, showIntercept = TRUE,
  stringIntercept = "(Intercept)", sort.coef = NULL, pred.labels = NULL,
  axisTitle.x = NULL, axisTitle.y = NULL, interceptLineType = 2,
  interceptLineColor = "grey70", showValueLabels = TRUE, labelDigits = 2,
  showPValueLabels = TRUE, facet.grid = TRUE, free.scale = FALSE,
  fade.ns = FALSE, show.se = TRUE, pointAlpha = 0.2,
  showScatterPlot = TRUE, showLoess = FALSE, showLoessCI = FALSE,
  poly.term = NULL, printPlot = TRUE)
}
\arguments{
\item{fit}{a fitted model as returned by the \code{\link[lme4]{lmer}}-function.}

\item{type}{type of plot. Use one of following:
\describe{
  \item{\code{"re"}}{(default) for estimates of random effects as forest plot}
  \item{\code{"fe"}}{for estimates of fixed effects as forest plot}
  \item{\code{"fe.std"}}{for standardized estimates of fixed effects as forest plot}
  \item{\code{"fe.pred"}}{to plot regression lines (slopes) with confidence intervals for each single fixed effect, i.e. all fixed terms are extracted and each is plotted against the response variable (linear relationship between each fixed term and response)}
  \item{\code{"fe.resid"}}{to plot regression lines (slopes) with confidence intervals for each single fixed effect (against residuals), i.e. all fixed terms are extracted and each is plotted against the model residuals (linear relationship between each fixed term and residuals)}
  \item{\code{"fe.cor"}}{for correlation matrix of fixed effects}
  \item{\code{"re.qq"}}{for a QQ-plot of random effects (random effects quantiles against standard normal quantiles)}
  \item{\code{"fe.ri"}}{for fixed effects slopes depending on the random intercept.}
  \item{\code{"resp"}}{to plot predicted values for the response, with and without random effects. Use \code{facet.grid} to decide whether to plot with and w/o random effect plots as separate plot or as integrated faceted plot.}
  \item{\code{"eff"}}{to plot marginal effects of all fixed terms in \code{fit}. Note that interaction terms are excluded from this plot; use \code{\link{sjp.int}} to plot effects of interaction terms. See also 'Details' of \code{\link{sjp.lm}}.}
  \item{\code{"poly"}}{to plot predicted values (marginal effects) of polynomial terms in \code{fit}. Use \code{poly.term} to specify the polynomial term in the fitted model (see 'Examples' here and 'Details' of \code{\link{sjp.lm}}).}
}}

\item{vars}{numeric vector with column indices of selected variables or a character vector with
variable names of selected variables from the fitted model, which should be used to plot
fixed effects slopes (for \code{\link[lme4]{lmer}}) or probability curves
(for \code{\link[lme4]{glmer}}) of random intercepts. This parameter only
applies if \code{type} is \code{"fe.pc"}, \code{"ri.pc"} or \code{"fe.ri"}.
In this case, only those terms specified in \code{"vars"} will be plotted.}

\item{ri.nr}{numeric vector. If \code{type = "re"}, \code{type = "ri.pc"} or \code{type = "fe.ri"},
and fitted model has more than one random intercept, \code{ri.nr} indicates
which random effects of which random intercept (or: which list elements
of \code{\link[lme4]{ranef}}) will be plotted. Default is \code{NULL},
so all random effects will be plotted.}

\item{emph.grp}{numeric vector with index numbers of grouping levels (from random effect).
If \code{type = "ri.pc"} or \code{type = "fe.ri"}, and \code{facet.grid = FALSE},
an integrated plot of predicted probabilities of fixed effects resp. fixed
effects slopes for each grouping level is plotted. To better find
certain groups, use this parameter to emphasize these groups in the plot.
See 'Examples'.}

\item{title}{character vector with one or more labels that are used as plot title. If
\code{type = "re"}, use the predictors' variable labels as titles.}

\item{geom.size}{size of geoms (point size or line size, depending on \code{type}-parameter).}

\item{geom.colors}{user defined color palette for geoms. Must either be vector with two color values
or a specific color palette code. See 'Note' in \code{\link{sjp.grpfrq}}.}

\item{hideErrorBars}{logical, if \code{TRUE}, the error bars that indicate the confidence intervals of the odds ratios are not
shown.}

\item{showIntercept}{logical, if \code{TRUE}, the intercept is included when plotting random or fixed effects.}

\item{stringIntercept}{string, label of intercept estimate on the y axis. Only applies, if \code{showIntercept}
is \code{TRUE} and \code{pred.labels} is not \code{NULL}.}

\item{sort.coef}{indicates which coefficient should be used for sorting odds ratios
\itemize{
  \item If \code{NULL} (default), no sorting is done and odds ratios are sorted in order of model coefficients.
  \item If \code{sort.coef = "sort.all"}, odds ratios are re-sorted for each coefficient (only applies if \code{type = "re"} and \code{facet.grid = FALSE}), i.e. the odds ratios of the random effects for each predictor are sorted and plotted to an own plot.
  \item If \code{type = "fe"} or \code{type = "fe.std"}, \code{TRUE} will sort estimates
  \item Else, specify a predictor's / coefficient's name to sort odds ratios according to this coefficient.
  }
  See 'Examples'.}

\item{pred.labels}{character vector with labels for the predictors / covariates / groups. Should either be vector
of fixed effects variable labels (if \code{type = "fe"} or \code{type = "fe.std"}) or a vector of group (value)
labels from the random intercept's categories (if \code{type = "re"}).}

\item{axisTitle.x}{title for the x axis. If not specified, a default labelling depending
on the plot type is chosen.}

\item{axisTitle.y}{title for the y axis. If not specified, a default labelling depending
on the plot type is chosen.}

\item{interceptLineType}{linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{color of the intercept line. Default value is \code{"grey70"}.}

\item{showValueLabels}{logical, whether estimate values should be plotted to each dot or not.}

\item{labelDigits}{numeric, amount of digits for rounding the estimates (see \code{showValueLabels}).
Default is 2, i.e. estimates have 2 digits after decimal point.}

\item{showPValueLabels}{logical, whether the significance levels of each coefficient should be appended
to values or not.}

\item{facet.grid}{\code{TRUE} when each plot should be plotted separately instead of
an integrated (faceted) single graph.}

\item{free.scale}{if \code{TRUE} and \code{facet.grid = TRUE}, each facet grid
         gets its own fitted scale. If \code{free.scale = FALSE}, each facet in
         the grid has the same scale range.}

\item{fade.ns}{if \code{TRUE}, non significant estimates will be printed in slightly faded colors.}

\item{show.se}{logical, use \code{TRUE} to plot (depending on \code{type}) the standard
error for predicted values or confidence intervals for slope lines.}

\item{pointAlpha}{alpha value of point-geoms in the scatter plots.
Default is 0.2.}

\item{showScatterPlot}{logical, if \code{TRUE} (default), a scatter plot of
response and predictor values for each predictor of the fitted
model \code{fit} is plotted. Only applies if \code{type = "fe.pred"}
or \code{type = "fe.resid"}.}

\item{showLoess}{logical, if \code{TRUE}, an additional loess-smoothed line is plotted.
For \code{\link{sjp.lmer}}, only applies \code{type = "fe.pred"} or
\code{type = "fe.resid"}.}

\item{showLoessCI}{logical, if \code{TRUE}, a confidence region for the loess-smoothed line
will be plotted. Default is \code{FALSE}. Only applies, if \code{showLoess = TRUE}
(and for \code{\link{sjp.lmer}}, only applies if \code{type = "fe.pred"}
or \code{type = "fe.resid"}).}

\item{poly.term}{name of a polynomial term in \code{fit} as string. Needs to be
         specified, if \code{type = "poly"}, in order to plot marginal effects
         for polynomial terms. See 'Examples'.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns
         \itemize{
           \item the ggplot-object (\code{plot}), if \code{type = "fe"} or if \code{type = "re"} and \code{facet.grid = TRUE}). Multiple plots (\code{type = "re"} and if \code{facet.grid = FALSE}) are returned in the object \code{plot.list}.
           \item a list of ggplot-objects (\code{plot.list}). see \code{plot} for details.
           \item a data frame \code{mydf} with the data used to build the ggplot-object(s).
           }
}
\description{
By default, this function plots estimates (coefficients) with confidence
               intervalls of either fixed effects or random effects of linear mixed
               effects models (that have been fitted with the \code{\link[lme4]{lmer}}-function
               of the \code{lme4} package). Furhermore, this function also plot
               predicted values or diagnostic plots.
}
\examples{
# fit model
library(lme4)
fit <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

# simple plot
sjp.lmer(fit)

# plot fixed effects
sjp.lmer(fit, type = "fe")

# sort by predictor Days
sjp.lmer(fit, sort.coef = "Days")

# plot each predictor as own plot
# sort each plot
sjp.lmer(fit,
         facet.grid = FALSE,
         sort.coef = "sort.all")


library(sjmisc)
data(efc)
# prepare group variable
efc$grp = as.factor(efc$e15relat)
levels(x = efc$grp) <- get_val_labels(efc$e15relat)
# data frame for fitted model
mydf <- data.frame(neg_c_7 = as.numeric(efc$neg_c_7),
                   sex = as.factor(efc$c161sex),
                   c12hour = as.numeric(efc$c12hour),
                   barthel = as.numeric(efc$barthtot),
                   grp = efc$grp)
# fit lmer
fit <- lmer(neg_c_7 ~ sex + c12hour + barthel + (1|grp),
            data = mydf)

# plot fixed effects
sjp.lmer(fit, type = "fe")

sjp.lmer(fit,
         type = "fe.std",
         sort.coef = TRUE)

# plot fixed effects slopes for
# each random intercept, but only for
# coefficient "c12hour"
sjp.lmer(fit,
         type = "fe.ri",
         vars = "c12hour")

# highlight specific grouping levels
# in this case we compare spouses, children
# and children-in-law
sjp.lmer(fit,
         type = "fe.ri",
         emph.grp = c(1, 2, 4),
         vars = "c12hour")

\dontrun{
# --------------------------
# plotting polynomial terms
# --------------------------
# check linear relation between predictors and response
sjp.lmer(fit, type = "fe.pred")

# "barthel" does not seem to be linear correlated to response
# try to find appropiate polynomial. Grey line (loess smoothed)
# indicates best fit. Looks like x^4 has the best fit,
# however, x^2 seems to be suitable according to p-values.
sjp.poly(fit, "barthel", 2:4, showScatterPlot = FALSE)

# fit new model
fit <- lmer(neg_c_7 ~ sex + c12hour + barthel +
            I(barthel^2) + (1|grp), data = mydf)

# plot marginal effects of polynomial term
sjp.lmer(fit, type = "poly", poly.term = "barthel")


# lme4 complaints about scale of polynomial term, so
# try centering this predictor
mydf$barthel_s <- scale(mydf$barthel, center = TRUE, scale = TRUE)

# re-fit model
fit_s <- lmer(neg_c_7 ~ sex + c12hour + barthel_s +
              I(barthel_s^2) + (1|grp), data = mydf)

# plot marginal effects of centered, scaled polynomial term
sjp.lmer(fit_s, type = "poly", poly.term = "barthel_s")

# scaling also improved p-values
sjt.lmer(fit, fit_s)}
}
\seealso{
\href{http://www.strengejacke.de/sjPlot/sjp.lmer/}{sjPlot manual: sjp.lmer}
}

