% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotAncovaLSMeans.R
\name{sjp.emm.int}
\alias{sjp.emm.int}
\title{Plot estimated marginal means of Two-Way Repeated Measures AN(C)OVA}
\usage{
sjp.emm.int(fit, swapPredictors = FALSE, plevel = 0.05, title = NULL,
  geom.colors = "Set1", axisTitle.x = NULL, axisTitle.y = NULL,
  axisLabels.x = NULL, legendTitle = NULL, legendLabels = NULL,
  showValueLabels = FALSE, valueLabel.digits = 2, showCI = FALSE,
  breakTitleAt = 50, breakLegendTitleAt = 20, breakLegendLabelsAt = 20,
  axisLimits.y = NULL, gridBreaksAt = NULL, printPlot = TRUE)
}
\arguments{
\item{fit}{the fitted linear (mixed effect) model (\code{\link{lm}} or \code{\link[lme4]{lmer}}),
including interaction terms.}

\item{swapPredictors}{if \code{TRUE}, the grouping variable and predictor on
the x-axis are swapped.}

\item{plevel}{Indicates at which p-value an interaction term is considered as \emph{significant},
i.e. at which p-level an interaction term will be considered for plotting. Default is
0.05 (5 percent), hence, non-significant interactions are excluded by default.}

\item{title}{a default title used for the plots. Default value is \code{NULL}, which means that each plot's title
includes the dependent variable as well as the names of the interaction terms.}

\item{geom.colors}{A vector of color values.}

\item{axisTitle.x}{a default title used for the x-axis. Default value is \code{NULL},
which means that each plot's x-axis uses the predictor's name as title.}

\item{axisTitle.y}{a default title used for the y-axis. Default value is \code{NULL},
which means that each plot's y-axis uses the dependent variable's name as title.}

\item{axisLabels.x}{Character vector with value labels of the repeated measure variable
that are used for labelling the x-axis.}

\item{legendTitle}{Character vector with title of the diagram's legend. Default is
\code{NULL}, so the name of the grouping variable is used as legend title.}

\item{legendLabels}{Labels for the guide/legend. Default is \code{NULL}, so the levels of
the grouping variable are used as legend labels.}

\item{showValueLabels}{if \code{TRUE}, value labels are plotted along the lines. Default is \code{FALSE}.}

\item{valueLabel.digits}{the amount of digits of the displayed value labels. Defaults to 2.}

\item{showCI}{If \code{TRUE}, a confidence region for the estimated marginal means
will be plotted.}

\item{breakTitleAt}{Wordwrap for diagram's title. Determines how many chars of the title are
displayed in one line and when a line break is inserted. Default is \code{50}.}

\item{breakLegendTitleAt}{Wordwrap for diagram legend title. Determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{breakLegendLabelsAt}{Wordwrap for diagram legend labels. Determines how many chars of the legend labels are
displayed in one line and when a line break is inserted. Default is \code{20}.}

\item{axisLimits.y}{A vector with two values, defining the lower and upper limit from the y-axis.
By default, this value is \code{NULL}, i.e. axis limits will be calculated upon the
range of y-values.}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed. Default is \code{NULL}.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-objects with the complete plot-list (\code{plot.list})
          as well as the data frame that were used for setting up the ggplot-objects (\code{df.list}).
}
\description{
Plot estimated marginal means (also called \emph{least square means} or
               \emph{marginal means}) of (significant) interaction terms in two-way
               repeated measure ANOVA or ANCOVA. The fitted models may be linear (mixed
               effects) models of class \code{\link{lm}} or \code{\link[lme4]{merMod}}.
               This function may be used to plot differences in interventions between
               control and treatment groups over multiple time points.
}
\note{
This function is deprecated and will be removed in future releases of \code{sjPlot}.
        Please use \code{\link{sjp.int}} with parameter \code{type = "emm"}.
}
\references{
\href{http://www.theanalysisfactor.com/using-adjusted-means-to-interpret-moderators-in-analysis-of-covariance/}{Grace-Martin K: Using Adjusted Means to Interpret Moderators in Analysis of Covariance.}
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjp.emm.int/}{sjPlot manual: sjp.emm.int}
           \item \href{http://strengejacke.wordpress.com/2014/08/19/visualize-pre-post-comparison-of-intervention-rstats/}{Weblog example}
         }
}

