% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjTabGrpmean.R
\name{sjt.grpmean}
\alias{sjt.grpmean}
\title{Summary of grouped means as HTML table}
\usage{
sjt.grpmean(varCount, varGrp, weightBy = NULL, rowLabels = NULL,
  digits = 2, digits.summary = 3, file = NULL, encoding = NULL,
  CSS = NULL, useViewer = TRUE, no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{varCount}{a numeric vector / variable. Mean, SD and SE for this variable are calculated.}

\item{varGrp}{a (numeric) vector with group indices, used to select sub-groups from \code{varCount}.}

\item{weightBy}{A weight factor that will be applied to weight all cases.
Must be a vector of same length as \code{varCount}. Default is \code{NULL}, 
so no weights are used.}

\item{rowLabels}{a character vector of same length as \code{varGrp} unqiue values. In short: the
value labels of \code{varGrp}. Used to name table rows. By default, row labels
are automatically detected if set by \code{\link[sjmisc]{set_labels}}.}

\item{digits}{amount of digits for table values.}

\item{digits.summary}{amount of digits for summary statistics (Anova).}

\item{file}{destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and 
openend either in the IDE's viewer pane or the default web browser.}

\item{encoding}{string, indicating the charset encoding used for variable and 
value labels. Default is \code{NULL}, so encoding will be auto-detected 
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{CSS}{\code{\link{list}}-object with user-defined style-sheet-definitions, according to the 
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns a \code{\link{list}} with
         \itemize{
           \item the data frame with the description information (\code{df}),
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inlin-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Computes mean, sd and se for each sub-group (indicated by \code{varGrp})
               of \code{varCount} and prints the result as HTML table.
}
\details{
This function performs a One-Way-Anova with \code{varCount} as dependent
           and \code{varGrp} as independent variable, by calling
           \code{lm(varCount ~ as.factor(varGrp))}, to get p-values for each
           sub-group and the complete "model". Thus, p-values indicate whether
           each group-mean is significantly different from the reference 
           group (reference level of \code{varGrp}). Statistics like mean values are
           based on subsetted groups (i.e. \code{varCount} is divided into sub-groups
           indicated by \code{varGrp}).
           \cr \cr
           Furthermore, see 'Details' in \code{\link{sjt.frq}}.
}
\note{
See 'Notes' in \code{\link{sjt.frq}}.
}
\examples{
\dontrun{
library(sjmisc)
data(efc)
sjt.grpmean(efc$c12hour,
            efc$e42dep)}
            
}
\seealso{
\code{\link{sjp.aov1}}
}

