% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatter.R
\name{plot_scatter}
\alias{plot_scatter}
\title{Plot (grouped) scatter plots}
\usage{
plot_scatter(data, x, y, grp, title = "", legend.title = NULL,
  legend.labels = NULL, dot.labels = NULL, axis.titles = NULL,
  dot.size = 1.5, label.size = 3, colors = "metro ui",
  fit.line = NULL, fit.grps = NULL, show.rug = FALSE,
  show.legend = TRUE, show.ci = FALSE, wrap.title = 50,
  wrap.legend.title = 20, wrap.legend.labels = 20, jitter = 0.05,
  emph.dots = FALSE, grid = FALSE)
}
\arguments{
\item{data}{A data frame, or a grouped data frame.}

\item{x}{Name of the variable for the x-axis.}

\item{y}{Name of the variable for the y-axis.}

\item{grp}{Optional, name of the grouping-variable. If not missing, the
scatter plot will be grouped. See 'Examples'.}

\item{title}{Character vector, used as plot title. By default,
\code{\link[sjlabelled]{get_dv_labels}} is called to retrieve the label of
the dependent variable, which will be used as title. Use \code{title = ""}
to remove title.}

\item{legend.title}{Character vector, used as legend title for plots that
have a legend.}

\item{legend.labels}{character vector with labels for the guide/legend.}

\item{dot.labels}{Character vector with names for each coordinate pair given
by \code{x} and \code{y}, so text labels are added to the plot.
Must be of same length as \code{x} and \code{y}.
If \code{dot.labels} has a different length, data points will be trimmed
to match \code{dot.labels}. If \code{dot.labels = NULL} (default),
no labels are printed.}

\item{axis.titles}{character vector of length one or two, defining the title(s)
for the x-axis and y-axis.}

\item{dot.size}{Numeric, size of the dots that indicate the point estimates.}

\item{label.size}{Size of text labels if argument \code{dot.labels} is used.}

\item{colors}{May be a character vector of color values in hex-format, valid
color value names (see \code{demo("colors")}) or a name of a pre-defined
color palette. Following options are valid for the \code{colors} argument:
\itemize{
  \item If not specified, a default color brewer palette will be used, which is suitable for the plot style.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{"bw"}, and plot-type is a line-plot, the plot is black/white and uses different line types to distinguish groups (see \href{../doc/blackwhitefigures.html}{this package-vignette}).
  \item If \code{colors} is any valid color brewer palette name, the related palette will be used. Use \code{\link[RColorBrewer]{display.brewer.all}} to view all available palette names.
  \item There are some pre-defined color palettes in this package, see \code{\link{sjPlot-themes}} for details.
  \item Else specify own color values or names as vector (e.g. \code{colors = "#00ff00"} or \code{colors = c("firebrick", "blue")}).
}}

\item{fit.line, fit.grps}{Specifies the method to add a fitted line accross
the data points. Possible values are for instance \code{"lm"}, \code{"glm"},
\code{"loess"} or \code{"auto"}. If \code{NULL}, no line is plotted.
\code{fit.line} adds a fitted line for the complete data, while \code{fit.grps}
adds a fitted line for each subgroup of \code{grp}.}

\item{show.rug}{Logical, if \code{TRUE}, a marginal rug plot is displayed
in the graph.}

\item{show.legend}{For \emph{Marginal Effects} plots, shows or hides the
legend.}

\item{show.ci}{Logical, if \code{TRUE)}, adds notches to the box plot, which are
used to compare groups; if the notches of two boxes do not overlap,
medians are considered to be significantly different.}

\item{wrap.title}{Numeric, determines how many chars of the plot title are
displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{wrap.legend.labels}{numeric, determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{jitter}{Numeric, between 0 and 1. If \code{show.data = TRUE}, you can
add a small amount of random variation to the location of each data point.
\code{jitter} then indicates the width, i.e. how much of a bin's width
will be occupied by the jittered values.}

\item{emph.dots}{Logical, if \code{TRUE}, overlapping points at same coordinates
will be becomme larger, so point size indicates amount of overlapping.}

\item{grid}{Logical, if \code{TRUE}, multiple plots are plotted as grid
layout.}
}
\value{
A ggplot-object. For grouped data frames, a list of ggplot-objects for
  each group in the data.
}
\description{
Display scatter plot of two variables. Adding a grouping variable to
  the scatter plot is possible. Furthermore, fitted lines can be added
  for each group as well as for the overall plot.
}
\examples{
# load sample date
library(sjmisc)
library(sjlabelled)
data(efc)

# simple scatter plot
plot_scatter(efc, e16sex, neg_c_7)

# simple scatter plot, increased jittering
plot_scatter(efc, e16sex, neg_c_7, jitter = .4)

# grouped scatter plot
plot_scatter(efc, c160age, e17age, e42dep)

# grouped scatter plot with marginal rug plot
# and add fitted line for complete data
plot_scatter(
  efc, c12hour, c160age, c172code,
  show.rug = TRUE, fit.line = "lm"
)

# grouped scatter plot with marginal rug plot
# and add fitted line for each group
plot_scatter(
  efc, c12hour, c160age, c172code,
  show.rug = TRUE, fit.grps = "loess",
  grid = TRUE
)

}
