% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{group_var}
\alias{group_var}
\title{Recode count variables into grouped factors}
\usage{
group_var(var, groupsize = 5, asNumeric = TRUE, rightInterval = FALSE,
  autoGroupCount = 30)
}
\arguments{
\item{var}{The count variable, which should recoded into groups.}

\item{groupsize}{The group-size, i.e. the range for grouping. By default, for each 5 categories
a new group is defined, i.e. \code{groupsize=5}. Use \code{groupsize="auto"} to automatically
resize a variable into a maximum of 30 groups (which is the ggplot-default grouping when
plotting histograms). Use \code{autoGroupCount} to determin the amount of groups.}

\item{asNumeric}{If \code{TRUE} (default), the recoded variable will be returned as numeric vector.
If \code{FALSE}, a factor is returned.}

\item{rightInterval}{If \code{TRUE}, grouping starts with the lower bound of \code{groupsize}. In this
case, groups cover the ranges from 50-54, 55-59, 60-64 etc. \cr
If \code{FALSE} (default), grouping starts with the upper bound of \code{groupsize}. In this
case, groups cover the ranges from 51-55, 56-60, 61-65 etc.}

\item{autoGroupCount}{Sets the maximum number of groups that are defined when auto-grouping is on
         (\code{groupsize="auto"}). Default is 30. If \code{groupsize} is not set to \code{"auto"},
         this parameter will be ignored.}
}
\value{
A grouped variable, either as numeric or as factor (see paramter \code{asNumeric}).
}
\description{
Recode count variables into grouped factors.
}
\examples{
age <- abs(round(rnorm(100, 65, 20)))
age.grp <- group_var(age, 10)
hist(age)
hist(age.grp)

# histogram with EUROFAMCARE sample dataset
# variable not grouped
data(efc)
efc.val <- get_val_labels(efc)
efc.var <- get_var_labels(efc)
\dontrun{
library(sjPlot)
sjp.frq(efc$e17age,
        title = efc.var[['e17age']],
        type = "h",
        showValueLabels = FALSE)}

# bar plot with EUROFAMCARE sample dataset
# grouped variable
data(efc)
efc.val <- get_val_labels(efc)
efc.var <- get_var_labels(efc)
ageGrp <- group_var(efc$e17age)
ageGrpLab <- group_labels(efc$e17age)
\dontrun{
library(sjPlot)
sjp.frq(ageGrp,
        title = efc.var[['e17age']],
        axisLabels.x = ageGrpLab)}
}
\seealso{
\itemize{
           \item \code{\link{group_labels}}
           \item \code{\link{group_str}}
         }
}

