% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{dicho}
\alias{dicho}
\title{Dichotomize variables}
\usage{
dicho(x, dichBy = "median", dichVal = -1, asNum = FALSE,
  varLabel = NULL, valLabels = NULL)
}
\arguments{
\item{x}{variable (vector), \code{data.frame} or \code{list} of variables
that should be dichotomized}

\item{dichBy}{indicates the split criterion where a variable is dichotomized
\describe{
  \item{\code{"median"}}{by default, \code{var} is split into two groups at the median. May be abbreviated as \code{"md"}.}
  \item{\code{"mean"}}{splits \code{var} into two groups at the mean of \code{var}. May be abbreviated as \code{"m"}.}
  \item{\code{"value"}}{splits \code{var} into two groups at a specific value (see \code{dichVal}). May be abbreviated as \code{"v"}.}
  }}

\item{dichVal}{numeric, indicates a value where \code{var} is dichotomized when \code{dichBy = "value"}.
\strong{Note that \code{dichVal} is inclusive}, i.e. \code{dichVal = 10} will split \code{var}
into one group with values from lowest to 10 and another group with values greater
than 10.}

\item{asNum}{logical, if \code{TRUE}, return value will be numeric, not a factor.}

\item{varLabel}{optional string, to set variable label attribute for the
dichotomized variable (see \code{\link{set_var_labels}}). If \code{NULL}
(default), variable label attribute of \code{x} will be used (if present).}

\item{valLabels}{optional character vector (of length two), to set value label
attributes of dichotomized variable (see \code{\link{set_val_labels}}).
If \code{NULL} (default), no value labels will be set.}
}
\value{
a dichotomized factor (or numeric, if \code{asNum = TRUE}) variable (0/1-coded),
          respectively a data frame or list of dichotomized factor (or numeric) variables.
}
\description{
Dichotomizes variables into dummy variables (0/1). Dichotomization is
               either done by median, mean or a specific value (see \code{dichBy}).
               Either single vectors, a complete data frame or a list of
               variables can be dichotomized.
}
\note{
Variable label attributes (see, for instance, \code{\link{set_var_labels}}) are retained
        (unless changes via \code{varLabel}-parameter).
}
\examples{
data(efc)
summary(efc$c12hour)
table(dicho(efc$c12hour))
table(dicho(efc$c12hour, "mean"))
table(dicho(efc$c12hour, "value", 30))

# sample data frame, values from 1-4
head(efc[, 6:10])
# dichtomized values (1 to 2 = 0, 3 to 4 = 1)
head(dicho(efc[, 6:10], "v", 2))

# dichtomize several variables in a list
dummy <- list(efc$c12hour, efc$e17age, efc$c160age)
dicho(dummy)

# dichotomize and set labels. requires package
# sjPlot to test
\dontrun{
library(sjPlot)
sjp.frq(dicho(efc$e42dep,
              varLabel = "Dependency (dichotomized)",
              valLabels = c("lower", "higher")))}
}

