% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_var.R
\name{group_var}
\alias{group_labels}
\alias{group_var}
\title{Recode numeric variables into equal-ranged groups}
\usage{
group_var(x, groupsize = 5, as.num = TRUE, right.interval = FALSE,
  groupcount = 30)

group_labels(x, groupsize = 5, right.interval = FALSE, groupcount = 30)
}
\arguments{
\item{x}{A variable, data frame or list-object.}

\item{groupsize}{Numeric; group-size, i.e. the range for grouping. By default,
for each 5 categories of \code{x} a new group is defined, i.e. \code{groupsize=5}.
Use \code{groupsize = "auto"} to automatically resize a variable into
a maximum of 30 groups (which is the ggplot-default grouping when
plotting histograms). Use \code{groupcount} to determine the amount
of groups.}

\item{as.num}{Logical; if \code{TRUE}, the recoded variable will
be returned as numeric vector. If \code{FALSE}, a factor is returned.}

\item{right.interval}{Logical; if \code{TRUE}, grouping starts with the lower
bound of \code{groupsize}. See 'Details'.}

\item{groupcount}{Sets the maximum number of groups that are defined when auto-grouping is on
(\code{groupsize="auto"}). Default is 30. If \code{groupsize} is not set to \code{"auto"},
this argument will be ignored.}
}
\value{
\itemize{
          \item For \code{group_var}, a grouped variable, either as numeric or as factor (see paramter \code{as.num}).
          \item For \code{group_label}, a string vector or a list of string vectors containing labels based on the grouped categories of \code{x}, formatted as "from lower bound to upper bound", e.g. \code{"10-19"  "20-29"  "30-39"} etc. See 'Examples'.
        }
}
\description{
Recode numeric variables into equal ranged, grouped factors,
               i.e. a variable is cut into a smaller number of groups,
               where each group has the same value range, and create the
               related value labels.
}
\details{
If \code{groupsize} is set to a specific value, the variable is recoded
           into several groups, where each group has a maximum range of \code{groupsize}.
           Hence, the amount of groups differ depending on the range of \code{x}.
           \cr \cr
           If \code{groupsize = "auto"}, the variable is recoded into a maximum of
           \code{groupcount} groups. Hence, independent from the range of
           \code{x}, always the same amount of groups are created, so the range
           within each group differs (depending on \code{x}'s range).
           \cr \cr
           \code{right.interval} determins which boundary values to include when
           grouping is done. If \code{TRUE}, grouping starts with the \strong{lower
           bound} of \code{groupsize}. For example, having a variable ranging from
           50 to 80, groups cover the ranges from  50-54, 55-59, 60-64 etc.
           If \code{FALSE} (default), grouping starts with the \code{upper bound}
           of \code{groupsize}. In this case, groups cover the ranges from
           46-50, 51-55, 56-60, 61-65 etc. \strong{Note:} This will cover
           a range from 46-50 as first group, even if values from 46 to 49
           are not present. See 'Examples'.
           \cr \cr
           If you want to split a variable into a certain amount of equal
           sized groups (instead of having groups where values have all the same
           range), use the \code{\link{split_var}} function!
}
\note{
Variable label attributes (see, for instance, \code{\link{set_label}}) are preserved.
      Usually you should use the same values for \code{groupsize} and
      \code{right.interval} in \code{group_label()} as used in the
      \code{group_var} function if you want matching labels for the related
      recoded variable.
}
\examples{
age <- abs(round(rnorm(100, 65, 20)))
age.grp <- group_var(age, 10)
hist(age)
hist(age.grp)

age.grpvar <- group_labels(age, 10)
table(age.grp)
print(age.grpvar)

# histogram with EUROFAMCARE sample dataset
# variable not grouped
data(efc)
hist(efc$e17age, main = get_label(efc$e17age))

# bar plot with EUROFAMCARE sample dataset
# grouped variable
ageGrp <- group_var(efc$e17age)
ageGrpLab <- group_labels(efc$e17age)
barplot(table(ageGrp), main = get_label(efc$e17age), names.arg = ageGrpLab)

# within a pipe-chain
library(dplyr)
efc \%>\% select(e17age, c12hour, c160age) \%>\% group_var(groupsize = 20)

# create vector with values from 50 to 80
dummy <- round(runif(200, 50, 80))
# labels with grouping starting at lower bound
group_labels(dummy)
# labels with grouping startint at upper bound
group_labels(dummy, right.interval = TRUE)

}
\seealso{
\code{\link{split_var}} to split variables into
         equal sized groups, \code{\link{group_str}} for grouping string vectors
         or \code{\link{rec_pattern}} and \code{\link{rec}} for another
         convenbient way of recoding variables into smaller groups.
}

