% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_values.R
\name{tidy_values}
\alias{tidy_values}
\alias{clean_values}
\title{Clean values of character vectors.}
\usage{
tidy_values(x, ...)

clean_values(x, ...)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
\code{\link[tidyselect]{select_helpers}}.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}
}
\value{
\code{x}, with "cleaned" values or levels.
}
\description{
This function "cleans" values of a character vector or levels of
  a factor by removing space and punctuation characters.
}
\examples{
f1 <- sprintf("Char \%s", sample(LETTERS[1:5], size = 10, replace = TRUE))
f2 <- as.factor(sprintf("F / \%s", sample(letters[1:5], size = 10, replace = TRUE)))
f3 <- sample(1:5, size = 10, replace = TRUE)

x <- data.frame(f1, f2, f3, stringsAsFactors = FALSE)

clean_values(f1)
clean_values(f2)
clean_values(x)

}
