% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_functions.R
\name{competencies}
\alias{competencies}
\title{Pull from Competencies API endpoint.}
\usage{
competencies(
  text,
  token,
  bias = NULL,
  exclude = NULL,
  handle_status = "warn",
  response_raw = FALSE
)
}
\arguments{
\item{text}{Sentence or text to pull relevant competencies for}

\item{token}{Authorization token obtained from \code{get_access_token}}

\item{bias}{Numeric value defining level of bias (Optional)}

\item{exclude}{Character vector of result elements to omit (Optional)}

\item{handle_status}{How to handle bad HTTP status. Set as either \code{warn} or \code{error}}

\item{response_raw}{Logical value whether to return the API response as
raw, unparsed text. Defaults to \code{FALSE}}
}
\value{
A list of length 9; competency data relevant to query
}
\description{
Pull from Competencies API endpoint.
}
\examples{
\dontrun{
tkn <- get_access_token(client_id, client_secret)
txt <- "i am a welder and used welding equipment and acetylene torches"
c <- competencies(text = txt, token = tkn, bias = 0.4)
}
}
