% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_optimality.R
\name{get_optimality}
\alias{get_optimality}
\title{Get optimality values}
\usage{
get_optimality(output, optimality = NULL)
}
\arguments{
\item{output}{The output of either gen_design or eval_design/eval_design_mc}

\item{optimality}{Default `NULL`. Return just the specific optimality requested.}
}
\value{
A dataframe of optimality conditions. `D`, `A`, and `G` are efficiencies (value is out of 100).
`T` is the trace of the information matrix, `E` is the minimum eigenvalue of the information matrix,
`I` is the average prediction variance, and `Alias` is the trace of the alias matrix.
}
\description{
Returns a list of optimality values (or one value in particular)
}
\examples{
# We can extract the optimality of a design from either the output of `gen_design()`
# or the output of `eval_design()`

factorialcoffee = expand.grid(cost = c(1, 2),
                             type = as.factor(c("Kona", "Colombian", "Ethiopian", "Sumatra")),
                             size = as.factor(c("Short", "Grande", "Venti")))

designcoffee = gen_design(factorialcoffee, ~cost + size + type, trials = 29,
                         optimality = "D", repeats = 100)

#Extract a list of all attributes
get_optimality(designcoffee)

#Get just one attribute
get_optimality(designcoffee,"D")

# Extract from `eval_design()` output
power_output = eval_design(designcoffee, model = ~cost + size + type,
                          alpha = 0.05, detailedoutput = TRUE)

get_optimality(power_output)
}
