\name{plot.single.slide}

\alias{plot.single.slide}
  
\title{M vs. A Plot}

\description{
For a single slide, this function produces a scatter plot of log
intensity ratios \eqn{M = log_2(R/G)} versus average log intensities
\eqn{A = log_2 \sqrt{RG}}{A = log_2(R*G)/2}, where R and G represent
the fluorescence intensities in the red and green channels
respectively, with the addition of coloured lines indicating the
cutoffs given by each of the three single slide methods.
}

\usage{
plot.single.slide(x,layout,norm="p",image.id=1,...)
}

\arguments{
  \item{x}{A list with at least 4 elements.  Each element of the list
    being a matrix with p rows for p genes and n columns for n slides. 
    The first element 'R' contains the raw red intensities,
    the second element 'G' contains the raw green intensities,
    the third element 'Rb' contains the background red intensities and
    the 4th element 'Gb' contains the background green intensities.
    This data structure can be generated by an interactive function
    \code{\link{init.data}}.}  

  \item{layout}{a list specifying the dimensions of the spot matrix
  and the grid matrix.  This can be generated by calling
  \code{\link{init.grid}}.} 

  \item{norm}{character string, one of "n", "m", "l", "p" or "s".  This
    argument  specifies the type of normalization method to be
    performed: "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization.} 
    
  \item{image.id}{integer value; the index of the slide which is
    considered.}
  \item{\dots}{additional graphical parameters}
}

\value{A plot is created on the current graphics device.  The plot is
an M vs A plot with lines indicating cuttoff for the three single
slide methods} 

\details{Plots an M vs A plot with results from each of the three single
slide methods, the methods of Newton, Sapir-Churchill and Chen,
indicated by colored lines. Solid black lines correspond to Newtons
method at 1:1, 1:10 and 1:100 log odds, note that the points are
colored red and green depending on where they fall according to this
method. Dashed lines are Chens method at the 95\% and 99\% confidence
levels. Dotted lines are Sapir-Churchil method at 95\% and 99\%
posterior probabilites.} 

\author{
  Ben Bolstad, \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{stat.Chen}}, \code{\link{stat.ChurSap}},
\code{\link{stat.Chen}}} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
plot.single.slide(mouse.data, mouse.setup, norm="p", image.id=3)
}     

%\keyword{microarray}

\keyword{hplot}




