% Generated by roxygen2 (4.0.2): do not edit by hand
\name{tolenv}
\alias{tolenv}
\alias{tolenv.renv}
\title{Tolerance envelopes for log ratio of spatial densities.}
\usage{
tolenv(object, level, direction)

\method{tolenv}{renv}(object, level = 0.95, direction = "both")
}
\arguments{
\item{object}{An \code{renv} object from the \code{logrr.env} function.}

\item{level}{Confidence level.  Should be a number between 0 and 1.  Default is 0.95.}

\item{direction}{Default is "both".  Can also be "upper" or "lower".}
}
\value{
Returns an \code{tolenvr} object.  This is just a list with components \code{x}, \code{y}, and \code{z} the can be used with the \code{image} or \code{contour} functions quite easily.
}
\description{
\code{tolenv} determines tolerance envelopes for the log ratio of spatial densities of cases and controls.  Specifically, the function identifies where the observed log ratio of spatial densities exceeds what is expected under the random labeling hypothesis.  Results can be easily plotted using the contour or image functions.
}
\details{
\code{direction="both"} identifies locations where the observed log ratio of spatial densities is below and above, respectively, the (1-level)/2 and 1 - (1-level)/2 quantiles of log ratios of spatial densities simulated under the random labeling hypothesis.  "upper" finds where the observed ratio exceeds the "level" quantile.  "lower" finds where the observed ratio exceeds the 1 - level quantile.

The \code{z} argument of the list returned has a -1 for locations where the observed log ratio of spatial densities is below the tolerance envelope, a 0 for locations within the tolerance envelope, and a 1 for locations where the log ratio of spatial densities exceeds the tolerance envelope.
}
\examples{
data(grave)
renv = logrr(grave, nsim = 9)
tol = tolenv(renv, level = 0.8)
image(tol, col = c("blue", "white", "orange"), asp = 1)
contour(renv, add = TRUE)
polygon(grave$window$bdry[[1]])
}
\author{
Joshua French
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.
}

