% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/spdensity.R
\name{spdensity}
\alias{spdensity}
\title{Kernel smoothed spatial density of point pattern}
\usage{
spdensity(x, sigma = NULL, ..., weights = NULL, edge = TRUE,
  varcov = NULL, at = "pixels", leaveoneout = TRUE, adjust = 1,
  diggle = FALSE)
}
\arguments{
\item{x}{Point pattern (object of class "ppp").}

\item{sigma}{Standard deviation of isotropic Gaussian smoothing kernel. Either a numerical value, or a function that computes an appropriate value of sigma.}

\item{...}{Additional arguments passed to pixellate.ppp and as.mask to determine the pixel resolution, or passed to sigma if it is a function.}

\item{weights}{Optional weights to be attached to the points. A numeric vector, numeric matrix, or an expression.}

\item{edge}{Logical flag: if TRUE, apply edge correction.}

\item{varcov}{Variance-covariance matrix of anisotropic Gaussian kernel. Incompatible with sigma.}

\item{at}{String specifying whether to compute the intensity values at a grid of pixel locations (at="pixels") or only at the points of x (at="points").}

\item{leaveoneout}{Logical value indicating whether to compute a leave-one-out estimator. Applicable only when at="points".}

\item{adjust}{Optional. Adjustment factor for the smoothing parameter.}

\item{diggle}{Logical. If TRUE, use Diggle's edge correction, which is more accurate but slower to compute than the correction described under Details.}
}
\value{
This function produces an object of class \code{im} from the \code{spatstat} package, in nearly the exact same way as \code{spatstat::density.ppp}.  The difference is that the values are scaled so that a true spatial density function is produced (i.e., the function integrates to 1).
}
\description{
\code{spdensity} computes a kernel smoothed spatial density function from a point pattern.  This is essentially a slight modification of the \code{density.ppp} function from the \code{spatstat} package, which computes the spatial intensity of a point pattern.
}
\examples{
data(grave)
contour(spdensity(grave))
}
\author{
Joshua French
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.
}
\seealso{
\code{\link[spatstat]{density.ppp}}
}

