% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spdensity.R
\name{spdensity}
\alias{spdensity}
\title{Kernel smoothed spatial density of point pattern}
\usage{
spdensity(
  x,
  sigma = NULL,
  ...,
  weights = NULL,
  edge = TRUE,
  varcov = NULL,
  at = "pixels",
  leaveoneout = TRUE,
  adjust = 1,
  diggle = FALSE,
  kernel = "gaussian",
  scalekernel = is.character(kernel),
  positive = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{
    Point pattern (object of class \code{"ppp"}).
  }

\item{sigma}{
    Standard deviation of isotropic smoothing kernel.
    Either a numerical value, or a function that computes an
    appropriate value of \code{sigma}.
  }

\item{...}{
    Additional arguments passed to \code{\link{pixellate.ppp}}
    and \code{\link{as.mask}} to determine
    the pixel resolution, or passed to \code{sigma} if it is a function.
  }

\item{weights}{
    Optional weights to be attached to the points.
    A numeric vector, numeric matrix, an \code{expression},
    or a pixel image.
  }

\item{edge}{
    Logical value indicating whether to apply edge correction.
  }

\item{varcov}{
    Variance-covariance matrix of anisotropic smoothing kernel.
    Incompatible with \code{sigma}.
  }

\item{at}{
    String specifying whether to compute the intensity values
    at a grid of pixel locations (\code{at="pixels"}) or
    only at the points of \code{x} (\code{at="points"}).
  }

\item{leaveoneout}{
    Logical value indicating whether to compute a leave-one-out
    estimator. Applicable only when \code{at="points"}.
  }

\item{adjust}{
    Optional. Adjustment factor for the smoothing parameter.
  }

\item{diggle}{
    Logical. If \code{TRUE}, use the Jones-Diggle improved edge correction,
    which is more accurate but slower to compute than the default
    correction.
  }

\item{kernel}{
    The smoothing kernel.
    A character string specifying the smoothing kernel
    (current options are \code{"gaussian"}, \code{"epanechnikov"},
    \code{"quartic"} or \code{"disc"}),
    or a pixel image (object of class \code{"im"})
    containing values of the kernel, or a \code{function(x,y)} which
    yields values of the kernel.
  }

\item{scalekernel}{
    Logical value.
    If \code{scalekernel=TRUE}, then the kernel will be rescaled
    to the bandwidth determined by \code{sigma} and \code{varcov}:
    this is the default behaviour when \code{kernel} is a character string.
    If \code{scalekernel=FALSE}, then \code{sigma} and \code{varcov}
    will be ignored: this is the default behaviour when \code{kernel} is a
    function or a pixel image.
  }

\item{positive}{
    Logical value indicating whether to force all density values to
    be positive numbers. Default is \code{FALSE}.
  }

\item{verbose}{
    Logical value indicating whether to issue warnings
    about numerical problems and conditions.
  }
}
\value{
This function produces the spatial density of \code{x}
as an object of class \code{im} from the \code{spatstat.core} package.
}
\description{
\code{spdensity} computes a kernel smoothed spatial
density function from a point pattern.  This function is
basically a wrapper for \code{\link[spatstat.core]{density.ppp}}.
The \code{\link[spatstat.core]{density.ppp}} function computes
the spatial intensity of a point pattern; the \code{spdensity}
function scales the intensity to produce a true spatial density.
}
\examples{
data(grave)
contour(spdensity(grave))
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.
}
\seealso{
\code{\link[spatstat.core]{density.ppp}}
}
\author{
Joshua French
}
