% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movmov.R
\name{rMM}
\alias{rMM}
\title{Sampling from a Moving-Moving Process with 2 Embedded Brownian Motion}
\usage{
rMM(time, lamM1, lamM2, sigma1, sigma2, s0, dim = 2)
}
\arguments{
\item{time}{time points at which observations are to be simulated}

\item{lamM1}{rate parameter of the exponential duration while moving1}

\item{lamM2}{rate parameter of the exponential duration while moving2}

\item{sigma1}{volatility parameter of the Brownian motion while moving1}

\item{sigma2}{volatility parameter of the Brownian motion while moving2}

\item{s0}{the state at time 0, must be one of "m1" or "m2", for moving1 and
moving2, respectively}

\item{dim}{(integer) dimension of the Brownian motion}
}
\value{
A \code{data.frame} whose first column is the time points and whose
other columns are coordinates of the locations.
}
\description{
A moving-moving process consists of two states: moving (large) and moving (small).
The transition between the two states is modeled by an alternating
renewal process, with exponentially distributed duration. An animal
moves according to two Brownian motions with different volatility parameters.
}
\examples{
tgrid <- seq(0, 100, length=100)

dat <- rMM(tgrid, 1, 0.1, 1, 0.1, "m1")
plot(dat[,1], dat[,2], xlab="t", ylab="X(t)", type='l')

}
\references{
Yan, J., Chen, Y., Lawrence-Apfel, K., Ortega, I. M., Pozdnyakov, V.,
Williams, S., and Meyer, T. (2014) A moving-resting process with an
embedded Brownian motion for animal movements.
Population Ecology. 56(2): 401--415.

Pozdnyakov, V., Elbroch, L., Labarga, A., Meyer, T., and Yan, J.
(2017) Discretely observed Brownian motion governed by telegraph
process: estimation. Methodology and Computing in Applied Probability.
doi:10.1007/s11009-017-9547-6.
}
