% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.metrics}
\alias{smbinning.metrics}
\title{Performance Metrics for a Classification Model}
\usage{
smbinning.metrics(dataset, prediction, actualclass, cutoff = NA, report = 1,
  plot = "none", returndf = 0)
}
\arguments{
\item{dataset}{Data frame.}

\item{prediction}{Classifier. A value generated by a classification model (Must be numeric).}

\item{actualclass}{Binary variable (0/1) that represents the actual class (Must be numeric).}

\item{cutoff}{Point at wich the classifier splits (predicts) the actual class (Must be numeric). 
If not specified, it will be estimated by using the maximum value of Youden J (Sensitivity+Specificity-1).
If not found in the data frame, it will take the closest lower value.}

\item{report}{Indicator defined by user. 1: Show report (Default), 2: Do not show report.}

\item{plot}{Specifies the plot to be shown for overall evaluation. It has three options: 'auc' shows the ROC curve, 
'ks' shows the cumulative distribution of the actual class and its maximum difference (KS Statistic), and 'none' (Default).}

\item{returndf}{Option for the user to save the data frame behind the metrics. 1: Show data frame, 0: Do not show (Default).}
}
\value{
The command \code{smbinning.metrics} returns a report with classic performance metrics of a classification model.
}
\description{
Performance Metrics for a Classification Model
}
\examples{
# Training and testing samples (Just some basic formality for Modeling)
pop=chileancredit # Set population
train=subset(pop,Rnd<=0.7) # Training sample
test=subset(pop,Rnd>0.7) # Testing sample
rm(chileancredit) # Remove original dataset

# Metrics application for Credit Score 1
smbinning.metrics(dataset=test,prediction="CuScore1",actualclass="FlagGB",
                  report=1) # Show report
smbinning.metrics(dataset=test,prediction="CuScore1",actualclass="FlagGB", 
                  cutoff=660, report=1) # User cutoff
smbinning.metrics(dataset=test,prediction="CuScore1",actualclass="FlagGB",
                  report=0, plot="auc") # Plot AUC
smbinning.metrics(dataset=test,prediction="CuScore1",actualclass="FlagGB",
                  report=0, plot="ks") # Plot KS
                  
# Save table with all details of metrics
CuSc1Metrics=smbinning.metrics(
  dataset=test,prediction="CuScore1",actualclass="FlagGB", 
  report=0, returndf=1) # Save metrics details
}
