% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tango.stat.R
\name{tango.stat}
\alias{tango.stat}
\title{Tango's statistic}
\usage{
tango.stat(cases, pop, w)
}
\arguments{
\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{An \eqn{n \times n} weights matrix.}
}
\value{
Returns a list with the test statistic
  (\code{tstat}), the goodness-of-fit component
  (\code{gof}), and the spatial autocorrelation component
  (\code{sa}).
}
\description{
\code{tango.stat} computes Tango's index (Tango, 1995),
including both the goodness-of-fit and spatial
autocorrelation components.  See Waller and Gotway
(2005).
}
\examples{
data(nydf)
coords <- as.matrix(nydf[, c("longitude", "latitude")])
w <- dweights(coords, kappa = 1, type = "tango", longlat = TRUE)
tango.stat(nydf$cases, nydf$pop, w)
}
\references{
Tango, T.  (1995) A class of tests for
  detecting "general" and "focused" clustering of rare
  diseases.  Statistics in Medicine.  14:2323-2334.

  Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial
  Statistics for Public Health Data.  Hoboken, NJ: Wiley.
}
\author{
Joshua French
}
