% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log-lik.R
\name{singl_ll_nn_hess}
\alias{singl_ll_nn_hess}
\title{Evaluate log-lik}
\usage{
singl_ll_nn_hess(
  theta,
  .dt,
  dists,
  npix,
  model,
  nu = NULL,
  tr = NULL,
  kappa = 1,
  mu2 = 1.5,
  apply_exp = FALSE
)
}
\arguments{
\item{theta}{a \code{numeric} vector of size \eqn{3} containing the
parameters values associated with \eqn{\mu}, \eqn{\sigma^2}, and
\eqn{\phi}, respectively.}

\item{.dt}{a \code{numeric} vector containing the variable \eqn{Y}.}

\item{dists}{a \code{list} of size three. The first containing the distance
matrices associated with the regions where \eqn{Y} was measured, the
second for the distance matrices associated with \eqn{X}, and the last
containing the cross-distance matrices.}

\item{npix}{a \code{integer vector} containing the number of pixels within
each polygon. (Ordered by the id variables for the polygons).}

\item{model}{a \code{character} indicating which covariance function to
use. Possible values are \code{c("matern", "pexp", "gaussian",
    "spherical")}.}

\item{nu}{\eqn{\nu} parameter. Not necessary if \code{mode} is
\code{"gaussian"} or \code{"spherical"}}

\item{tr}{taper range}

\item{kappa}{\eqn{\kappa \in \{0, \ldots, 3 \}} parameter for the GW cov
function.}

\item{mu2}{the smoothness parameter \eqn{\mu} for the GW function.}

\item{apply_exp}{a \code{logical} indicater wheter the exponential
transformation should be applied to variance parameters. This
facilitates the optimization process.}
}
\value{
a scalar representing \code{-log.lik}.
}
\description{
Evaluate the log-likelihood for a given set of parameters
}
\details{
Internal use.
}
\keyword{internal}
