% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{comp_gw_cov}
\alias{comp_gw_cov}
\title{Generalized Wendland covariance function for a polygons.}
\usage{
comp_gw_cov(cross_dists, n, n2, sigsq, phi, kappa, mu)
}
\arguments{
\item{cross_dists}{a \code{list} such that each position contains the cross
distances between points within different polygons.}

\item{n}{an integer representing number of polygons (note that, this is
different than the size of the list \code{cross_dists}}

\item{n2}{usually, equal to \code{n}, except when the function is being used
to calculate the "cross" covariance between two different partitions of
the same space.}

\item{sigsq}{the \eqn{\sigma^2} variance of the covariance function
function.}

\item{phi}{the \eqn{\phi} is the range parameter of the covariance function.}

\item{kappa}{\eqn{\kappa \in \{0, \ldots, 3 \}}.}

\item{mu}{\eqn{\mu} controls the smoothness of the covariance function}
}
\value{
The wendland-1 covariance matrix associated with a set of polygons.
}
\description{
Computing the Matern covariance function between polygons.
}
\keyword{internal}
