% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smog.R
\name{plot.smog}
\alias{plot.smog}
\title{plot method for objects of \code{smog} class}
\usage{
\method{plot}{smog}(x, type = "l", xlab = "iteration",
  caption = list("primal error", "dual error", "log-likelihood"), ...)
}
\arguments{
\item{x}{a fitted object of class inheriting from smog.}

\item{type, xlab}{default line types and x axis labels for the panel of plots.}

\item{caption}{a list of y axes labels for the panel of plots.}

\item{...}{additional arguments that could be supplied to \code{\link[graphics]{plot.default}}
and \code{\link[graphics]{par}}.}
}
\description{
\code{plot.smog} can produce a panel of plots for the primal errors, dual errors,
and the penalized log-likelihood values, based on the provided fitted model
(\code{x}) in the S3method of \code{smog}.
}
\details{
For the panel of three plots, the \code{xlab} is ''iterations'' and the
\code{type} is ''l'', by default. The \code{ylab} are ''primal error'',
''dual error'',''log-likelihood'', respectively. This panel of plots can
reflect the convergence performance for the algorithm used in \code{\link{smog}}.
}
\references{
\insertRef{ma2019structural}{smog}
}
\seealso{
\code{\link[graphics]{par}}, \code{\link[graphics]{plot.default}},
\code{\link{predict.smog}}, \code{\link{smog.default}}, \code{\link{cv.smog}}.
}
\author{
Chong Ma, \email{chongma8903@gmail.com}.
}
