% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simves.R
\name{sim.ves}
\alias{sim.ves}
\title{Simulate Vector Exponential Smoothing}
\usage{
sim.ves(model = "ANN", obs = 10, nsim = 1, nSeries = 2,
  frequency = 1, persistence = NULL, phi = 1, transition = NULL,
  initial = NULL, initialSeason = NULL, bounds = c("usual",
  "admissible", "restricted"), randomizer = c("rnorm", "rt", "rlaplace",
  "rs"), ...)
}
\arguments{
\item{model}{Type of ETS model. This can consist of 3 or 4 chars:
\code{ANN}, \code{AAN}, \code{AAdN}, \code{AAA}, \code{AAdA} etc.
Only pure additive and pure multiplicative models are supported. In the
latter case the data is generated using additive model and then
exponentiated.}

\item{obs}{Number of observations in each generated time series.}

\item{nsim}{Number of series to generate (number of simulations to do).}

\item{nSeries}{Number of series in each generated group of series.}

\item{frequency}{Frequency of generated data. In cases of seasonal models
must be greater than 1.}

\item{persistence}{Matrix of smoothing parameters for all the components
of all the generated time series.}

\item{phi}{Value of damping parameter. If trend is not chosen in the model,
the parameter is ignored. If vector is provided, then several parameters
are used for different series.}

\item{transition}{Transition matrix. This should have the size appropriate
to the selected model and \code{nSeries}. e.g. if ETS(A,A,N) is selected
and \code{nSeries=3}, then the transition matrix should be 6 x 6. In case
of damped trend, the phi parameter should be placed in the matrix manually.
if \code{NULL}, then the default transition matrix for the selected type
of model is used. If both \code{phi} and \code{transition} are provided,
then the value of \code{phi} is ignored.}

\item{initial}{Vector of initial states of level and trend. The minimum
length is one (in case of ETS(A,N,N), the initial is used for all the
series), the maximum length is 2 x nSeries. If \code{NULL}, values are
generated for each series.}

\item{initialSeason}{Vector or matrix of initial states for seasonal
coefficients. Should have number of rows equal to \code{frequency}
parameter. If \code{NULL}, values are generated for each series.}

\item{bounds}{Type of bounds to use for persistence vector if values are
generated. \code{"usual"} - bounds from p.156 by Hyndman et. al., 2008.
\code{"restricted"} - similar to \code{"usual"} but with upper bound equal
to 0.3. \code{"admissible"} - bounds from tables 10.1 and 10.2 of Hyndman
et. al., 2008. Using first letter of the type of bounds also works.}

\item{randomizer}{Type of random number generator function used for error
term. Defaults are: \code{rnorm}, \code{rt}, \code{rlaplace}, \code{rs}. But
any function from \link[stats]{Distributions} will do the trick if the
appropriate parameters are passed. \code{mvrnorm} from MASS package can also
be used.}

\item{...}{Additional parameters passed to the chosen randomizer. All the
parameters should be passed in the order they are used in chosen randomizer.
For example, passing just \code{sd=0.5} to \code{rnorm} function will lead
to the call \code{rnorm(obs, mean=0.5, sd=1)}. ATTENTION! When generating
the multiplicative errors some tuning might be needed to obtain meaningful
data. \code{sd=0.1} is usually already a high value for such models.}
}
\value{
List of the following values is returned:
\itemize{
\item \code{model} - Name of ETS model.
\item \code{data} - The matrix (or an array if \code{nsim>1}) of the
generated series.
\item \code{states} - The matrix (or array if \code{nsim>1}) of states.
States are in columns, time is in rows.
\item \code{persistence} - The matrix (or array if \code{nsim>1}) of
smoothing parameters used in the simulation.
\item \code{transition} - The transition matrix (or array if \code{nsim>1}).
\item \code{initial} - Vector (or matrix) of initial values.
\item \code{initialSeason} - Vector (or matrix) of initial seasonal
coefficients.
\item \code{residuals} - Error terms used in the simulation. Either matrix
or array, depending on \code{nsim}.
}
}
\description{
Function generates data using VES model as a data generating process.
}
\examples{

# Create 40 observations of quarterly data using AAA model with errors
# from normal distribution
\dontrun{VES.AAA <- sim.ves(model="AAA",frequency=4,obs=40,nSeries=3,
                   randomizer="rnorm",mean=0,sd=100)}

# You can also use mvrnorm function from MASS package as randomizer,
# but you need to provide mu and Sigma explicitly
\dontrun{VES.ANN <- sim.ves(model="ANN",frequency=4,obs=40,nSeries=2,
                   randomizer="mvrnorm",mu=c(100,50),Sigma=matrix(c(40,20,20,30),2,2))}

}
\references{
\itemize{
\item de Silva A,, Hyndman R.J. and Snyder, R.D. (2010). The vector
innovations structural time series framework: a simple approach to
multivariate forecasting. Statistical Modelling, 10 (4), pp.353-374
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \url{http://www.exponentialsmoothing.net}.
}
}
\seealso{
\code{\link[smooth]{es}, \link[forecast]{ets},
\link[forecast]{forecast}, \link[stats]{ts}, \link[stats]{Distributions}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{multivariate}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
