% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{groupseqDATA_full}
\alias{groupseqDATA_full}
\title{Group sequential full data}
\format{
This data frame contains the following columns:
\describe{
\item{time.1st.trt}{first treatment time}
\item{time.1st.resp}{first response time}
\item{time.2nd.trt}{second treatment time}
\item{time.2nd.resp}{second response time}
\item{trt.1st}{treatment arm for first treatment}
\item{resp.1st}{response for first treatment}
\item{trt.2nd}{treatment arm for second treatment}
\item{resp.2nd}{response for second treatment}
}
}
\usage{
groupseqDATA_full
}
\description{
sample dataset of group sequential trial design snSMART, can be used for final analysis
}
\examples{
mydata <- groupseqDATA_full
result2 <- group_seq(
  data = mydata, interim = FALSE, prior_dist = c(
    "beta", "beta", "pareto"
  ), pi_prior = c(0.4, 1.6, 0.4, 1.6, 0.4, 1.6),
  beta_prior = c(1.6, 0.4, 3, 1), MCMC_SAMPLE = 6000, n.adapt = 1000,
  n_MCMC_chain = 1, ci = 0.95, DTR = TRUE
)
}
\keyword{data}
