% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsmi_union.R
\name{lsmi_union}
\alias{lsmi_union}
\title{Snowball Sampling with Multiple Inclusions around Several Subsets of Seeds}
\usage{
lsmi_union(net, n.seeds, n.wave, seeds = NULL)
}
\arguments{
\item{net}{a network object that is a list containing:
\describe{
  \item{\code{degree}}{the degree sequence of the network, which is
     an \code{integer} vector of length \eqn{n};}
  \item{\code{edges}}{the edgelist, which is a two-column
     matrix, where each row is an edge of the network;}
  \item{\code{n}}{the network order (i.e., number of nodes in the network).}
}
The network object can be simulated by \code{\link{random_network}},
selected from the networks available in \code{\link{artificial_networks}},
converged from an \code{igraph} object with \code{\link{igraph_to_network}},
etc.}

\item{n.seeds}{an integer vector of numbers of seeds for snowball sampling
(cf. a single integer \code{n.seed} in \code{\link{lsmi}}). Only
\code{n.seeds <= n} are retained. If \code{seeds} is
specified, only values \code{n.seeds < length(unique(seeds))} are retained
and automatically supplemented by \code{length(unique(seeds))}.}

\item{n.wave}{an integer defining the number of waves (order of the neighborhood)
to be recorded around the seed in the LSMI. For example, \code{n.wave = 1} corresponds to
an LSMI with the seed and its first neighbors. Note that the algorithm allows for
multiple inclusions.}

\item{seeds}{a vector of numeric IDs of pre-specified seeds. If specified,
LSMIs are constructed around each such seed.}
}
\value{
A list with two elements:
  \item{lsmi_big}{LSMI with \code{max(n.seeds)} seeds (see the argument definition
  above) and \code{n.wave} waves produced by the \code{\link{lsmi}} function.}
  \item{sequence_seeds}{A list of length equal to \code{length(n.seeds)};
  each element of the list is a random subset of the seeds' IDs, starting from
  the largest (a set of size \code{max(n.seeds)}) to the smallest
  (a set of size \code{min(n.seeds)}).}
}
\description{
Obtain one big LSMI -- with \code{max(n.seeds)} seeds and \code{n.wave}
waves around each -- and subsample seeds to create smaller LSMIs (with less
seeds and/or waves). The function is primarily used in cross-validation.
}
\details{
Note that the produced LSMIs are slightly different from those described by
\insertCite{gel_etal_2017;textual}{snowboot}. The current R implementation
produces smaller LSMIs by subsetting the seeds, not by new sampling of
seeds from the network and growing completely new LSMIs, as it was done by
\insertCite{gel_etal_2017;textual}{snowboot}.
}
\examples{
net <- artificial_networks[[1]]
a <- lsmi_union(net, n.seeds = c(5, 10, 15), n.wave = 2)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{sample_about_one_seed}}, \code{\link{lsmi}}, \code{\link{lsmi_cv}}
}
