% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertboot.R
\name{vertboot}
\alias{vertboot}
\title{Bootstrapping a Network with Vertex Bootstrap}
\usage{
vertboot(m1, boot_rep)
}
\arguments{
\item{m1}{An adjacency matrix of the original network.}

\item{boot_rep}{A positive integer number, the number of bootstrap replications.}
}
\value{
A list of bootstrapped networks as adjacency matrices.
}
\description{
This function bootstraps the original network using a vertex bootstrap technique.
}
\examples{
graph_ex <- igraph::graph_from_edgelist(artificial_networks[[1]]$edges)
m1 <- igraph::as_adjacency_matrix(graph_ex)
m1 <- as.matrix(m1)
vertboot_out <- vertboot(m1, 20)
}
\references{
\insertRef{snijders_borgatti_1999}{snowboot}
}
