% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snvec.R
\name{snvec}
\alias{snvec}
\title{Calculate Earth’s Obliquity and Precession in the Past}
\usage{
snvec(
  tend = -1000,
  ed = 1,
  td = 0,
  orbital_solution = "ZB18a",
  tres = 0.4,
  atol = 1e-05,
  rtol = 0,
  solver = "vode",
  quiet = FALSE,
  output = "nice"
)
}
\arguments{
\item{tend}{Final timestep in thousands of years before present (ka).
Defaults to \code{-1000} ka.}

\item{ed}{Dynamical ellipticity \eqn{E_{d}}{Ed}, normalized to modern.
Defaults to \code{1.0}.}

\item{td}{Tidal dissipation \eqn{T_{d}}{Td}, normalized to modern. Defaults
to \code{0.0}.}

\item{orbital_solution}{Character vector with the name of the orbital
solution to use. One of \code{"ZB18a"} (default) from Zeebe and Lourens (2019),
or \code{"La11"} (not yet implemented!).}

\item{tres}{Output timestep resolution in thousands of years (kyr). Defaults
to \code{0.4}.}

\item{atol}{Numerical absolute tolerance passed to \code{\link[deSolve:ode]{deSolve::ode()}}'s
\code{atol}. Defaults to \code{1e-5}.}

\item{rtol}{Numerical relative tolerance passed to \code{\link[deSolve:ode]{deSolve::ode()}}'s
\code{rtol}. Defaults to \code{0}.}

\item{solver}{Character vector specifying the method passed to
\code{\link[deSolve:ode]{deSolve::ode()}}'s \code{method}. Defaults to \code{"vode"} for stiff problems
with a variable timestep.}

\item{quiet}{Be quiet?
\itemize{
\item If \code{TRUE}, hide info messages.
\item If \code{FALSE} (the default) print info messages and timing.
}}

\item{output}{Character vector with name of desired output. One of:
\itemize{
\item \code{"nice"} (the default) A \link[tibble:tibble-package]{tibble} with the
columns \code{time}, \code{age}, \code{eei}, \code{epl}, \code{phi}, \code{cp}.
\item \code{"full"} A \link[tibble:tibble-package]{tibble} with all the computed and
interpolated columns.
\item \code{"ode"} A matrix with the output of the ODE solver.
}}
}
\value{
\code{snvec()} returns different output depending on the \code{outputs} argument.

If \code{output = "nice"} (the default), returns a
\link[tibble:tibble-package]{tibble} with the following columns:
\itemize{
\item \code{time} Time \eqn{t} (days).
\item \code{age} Age in thousands of years ago (ka).
\item \code{eei} Orbital solution's eccentricity \eqn{e}, interpolated to output
timescale (-).
\item \code{epl} Calculated Obliquity \eqn{\epsilon} (radians).
\item \code{phi} Calculated Precession \eqn{\phi} (radians) from ECLIPJ2000.
\item \code{cp} Calculated Climatic precession (-) as \eqn{e\sin(\varpi)}.
}

where \eqn{\varpi} is the longitude of perihelion relative to the moving equinox.

If \code{output = "all"} (for developers), additional columns are included,
typically interpolated to output timescale.
\itemize{
\item \code{sx}, \code{sy}, \code{sz} The \eqn{x}, \eqn{y}, and \eqn{z}-components of Earth's
spin axis unit vector \eqn{\vec{s}}{s} in the heliocentric inertial
reference frame.
}

See the source code for descriptions of all the intermediate computational
steps.

If \code{output = "ode"}, it will return the raw output of the ODE solver, which
is an object of class \code{deSolve} and \code{matrix}, with columns \code{time}, \code{sx},
\code{sy}, and \code{sz} (see above). This can be useful for i.e.
\code{\link[deSolve:diagnostics]{deSolve::diagnostics()}}.
}
\description{
\code{snvec()} computes climatic precession and obliquity (or tilt) from an
orbital solution (OS) input and input values for dynamical ellipticity
(\eqn{E_{d}}{Ed}) and tidal dissipation (\eqn{T_{d}}{Td}). It solves a set
of ordinary differential equations.
}
\details{
This is a re-implementation of the C-code in the supplementary
information of Zeebe & Lourens (2022). The terms are explained in detail
in Zeebe (2022).

Note that the different ODE solver algorithm we use (Soetaert et al.,
2010) means that the R routine returns an evenly-spaced time grid, whereas
the C-routine has a variable time-step.
}
\examples{
# default call
\donttest{
snvec()
}
}
\references{
Zeebe, R. E., & Lourens, L. J. (2019). Solar System chaos and the
Paleocene–Eocene boundary age constrained by geology and astronomy.
\emph{Science}, 365(6456), 926–929. \doi{10.1126/science.aax0612}.

Zeebe, R. E., & Lourens, L. J. (2022). A deep-time dating tool for
paleo-applications utilizing obliquity and precession cycles: The role of
dynamical ellipticity and tidal dissipation. \emph{Paleoceanography and
Paleoclimatology}, e2021PA004349. \doi{10.1029/2021PA004349}.

Zeebe, R. E. (2022). Reduced Variations in Earth’s and Mars’ Orbital
Inclination and Earth’s Obliquity from 58 to 48 Myr ago due to Solar
System Chaos. \emph{The Astronomical Journal}, 164(3),
\doi{10.3847/1538-3881/ac80f8}.

Wikipedia page on Orbital Elements:
\url{https://en.wikipedia.org/wiki/Orbital_elements}

Karline Soetaert, Thomas Petzoldt, R. Woodrow Setzer (2010). Solving
Differential Equations in R: Package deSolve. Journal of Statistical
Software, 33(9), 1–25. \doi{10.18637/jss.v033.i09}.
}
\seealso{
\itemize{
\item \code{\link[deSolve:ode]{deSolve::ode()}} from Soetaert et al., (2010) for the ODE solver that we
use.
\item \code{\link[=get_ZB18a]{get_ZB18a()}} Documents the default orbital solution input.
\item \code{\link[=get_solution]{get_solution()}} A general function that in the future may be used to get
other orbital solutions.
}
}
