
context("extract_bpts")

test_that("extract_bpts should be able to generate a bpts table from two vectors",{
  set.seed(0)
  a = rnorm(10,0,1)
  b = rnorm(10,0,1)
  bpts <- extract_bpts(a,b)
  expect_equal(bpts[c(1,16,25),4], factor(c(1,5,6), levels = 0:6))
})

context("bpts_plot")

test_that("bpts_plot should create a ggplot2 scatterplot using the bpts table generated by extract_bpts",{
  set.seed(0)
  a = rnorm(10,0,1)
  b = rnorm(10,0,1)
  bpts <- extract_bpts(a,b)
  bfig <- bpts_plot(bpts)
  expect_equal(class(bfig$plot_env$bpts_graph)[2], "ggplot")
})

context("calc_area")

test_that("calc_area should return a list of the three no-data zone areas unsing two vectors",{
  set.seed(0)
  a = rnorm(20,0,1)
  b = rnorm(20,0,1)
  barea = calc_area(a,b)
  expect_lt(barea$botr, 0.3)
  expect_gt(barea$botr, 0.2)
})

context("perm_area")

test_that("perm_area should calculate the no-data zone areas for each permutation of the data simulated nsim times",{
  set.seed(0)
  a = rnorm(10,0,1)
  b = rnorm(10,0,1)
  bperm = perm_area(a,b,5, boundary = "topl")
  expect_lt(bperm$data[6,4], 0.6)
  expect_gt(bperm$data[6,4], 0.5)
})

context("perm_plot")

test_that("perm_plot should pull the appropriate data from the perm_area analysis",{
  set.seed(0)
  a = rnorm(10,0,1)
  b = rnorm(10,0,1)
  bperm = perm_area(a,b,5, boundary = "topl")
  bpplot = perm_plot(bperm,20)
  expect_lt(bpplot$data[5,4], 0.7)
  expect_gt(bpplot$data[5,4], 0.6)
})
