\docType{package}
\name{soc.ca}
\alias{soc.ca}
\alias{soc.ca-package}
\title{Soc.ca a package for specific correspondence analysis}
\description{
This package is optimized to the needs of scientists within
the social sciences. The soc.ca package produces specific
and class specific multiple correspondence analysis on
survey-like data. Soc.ca is optimized to only give the most
essential statistical output sorted so as to help in
analysis. Seperate functions exists for near
publication-ready plots and tables.
}
\details{
We are in debt to the work of others, especially Brigitte
Le Roux and Henry Rouanet for the mathematical definitions
of the method and their examples. Furthermore this package
was initially based on code from the ca package written by
Michael Greenacre and Oleg Nenadic.

If you are looking for features that are absent in soc.ca,
it may be available in some of these packages for
correspondence analysis: \pkg{ca}, \pkg{anacor} and
\pkg{FactoMineR}.
}
\examples{
data(taste)
# Create a data frame of factors containing all the active variables
taste          <- taste[which(taste$Isup == 'Active'), ]

attach(taste)
active         <- data.frame(TV, Film, Art, Eat)
sup            <- data.frame(Gender, Age, Income)
detach(taste)

# Runs the analysis
result         <- soc.mca(active, sup)
}
\references{
Le Roux, Brigitte, and Henry Rouanet. 2010. Multiple
correspondence analysis. Thousand Oaks: Sage.

Le Roux, Brigitte, and Henry Rouanet. 2004. Geometric Data
Analysis from Correspondence Analysis to Structured Data
Analysis.  Dordrecht: Kluwer Academic Publishers.
}

