% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.r
\name{clean}
\alias{clean}
\alias{clean.survey}
\title{Clean contact survey data}
\usage{
\method{clean}{survey}(x, sample.contact.age = TRUE,
  contact.age.column = "cnt_age", country.column = "country",
  quiet = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{survey}} object}

\item{sample.contact.age}{whether the contact age should be sampled if it does not exist in the data}

\item{contact.age.column}{the name of the contact age column; if this does not exist, the function will try to construct it from "..._exact", "..._est_min" and "..._est_max" (unless \code{sample.contact.age} is set to FALSE)}

\item{country.column}{the name of the country denoting the country in which the survey participant was interviewed}

\item{quiet}{if TRUE,  will suppress output}

\item{...}{ignored}
}
\value{
invisibly returns a character vector of the relevant columns

a cleaned survey in the correct format
}
\description{
Cleans survey data to work with the 'contact_matrix' function
}
\examples{
data(polymod)
cleaneed <- clean(polymod) # not really necessary as the 'polymod' data set has already been cleaned
}
