% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{elections_historic}
\alias{elections_historic}
\title{US Presidential Election vote shares}
\format{A (tibble) data frame with 237 rows and 21 variables.}
\source{
https://en.wikipedia.org/wiki/List_of_United_States_presidential_elections_by_popular_vote_margin.
}
\usage{
elections_historic
}
\description{
A dataset of US presidential elections from 1824 to 2016, with
 information on the winner, runner up, and various measures of vote
 share. Data for 2016 are provisional as of early December 2016.
 The variables are as follows:
}
\details{
\itemize{
\item election. Number of the election counting from the first US
presidential election. 1824 is the 10th election.
\item year. Year.
\item winner. Full name of winner.
\item win_party. Party affiliation of winner.
\item ec_pct. Winner's share of electoral college vote.
(Range is 0 to 1.)
\item popular_pct. Winner's share of popular vote. (Range is 0 to 1.)
\item popular_margin. Winner's point margin in the popular vote.
Can be positive or negative.
\item votes. Total votes cast in the election.
\item margin. Winner's vote margin in the popular vote.
\item runner_up. Runner up candidate.
\item ru_part. Party affiliation of runner up candidate.
\item turnout_pct. Voter turnout as a proportion of eligible
voters. (Rate is 0 to 1.)
\item winner_lname Last name of winner.
\item winner_label Winner's last name and election year.
\item ru_lastname. Runner up's last name.
\item ru_label. Runner up's last name and election year.
\item two_term. Is this a two term presidency? (TRUE/FALSE.) Note
that F.D. Roosevelt was elected four times.
\item ec_votes. Electoral college votes cast for winner.
\item ec_denom. Total number of electoral college votes.
}
}
\keyword{datasets}
