% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach.r
\name{attachments}
\alias{attachments}
\alias{doc_attach_create}
\alias{doc_attach_delete}
\alias{doc_attach_get}
\alias{doc_attach_info}
\title{Work with attachments}
\usage{
doc_attach_create(cushion, dbname, docid, attachment, attname, as = "list",
  ...)

doc_attach_info(cushion, dbname, docid, attname, ...)

doc_attach_get(cushion, dbname, docid, attname, type = "raw", ...)

doc_attach_delete(cushion, dbname, docid, attname, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{Cushion} object. Required.}

\item{dbname}{(charcter) Database name. Required.}

\item{docid}{(charcter) Document ID. Required.}

\item{attachment}{(charcter) A file name. Required.}

\item{attname}{(charcter) Attachment name. Required.}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to one of the HTTP verbs (e.g,.
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, \code{\link[httr]{PUT}},
etc.)}

\item{type}{(character) one of raw (default) or text. required.}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Work with attachments
}
\details{
Methods:
\itemize{
 \item doc_attach_create - create an attachment
 \item doc_attach_info - get info (headers) for an attachment
 \item doc_attach_get - get an attachment. this method does not attempt
 to read the object into R, but only gets the raw bytes or plain
 text. See examples for how to read some attachment types
 \item doc_attach_delete - delete and attachment
}
}
\examples{
\dontrun{
(x <- Cushion$new())

if ("drinksdb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="drinksdb"))
}
db_create(x, dbname='drinksdb')

# create an attachment on an existing document
## create a document first
doc <- '{"name":"stuff", "drink":"soda"}'
doc_create(x, dbname="drinksdb", doc=doc, docid="asoda")

## create a csv attachment
row.names(mtcars) <- NULL
file <- tempfile(fileext = ".csv")
write.csv(mtcars, file = file, row.names = FALSE)
doc_attach_create(x, dbname="drinksdb", docid="asoda",
  attachment=file, attname="mtcarstable.csv")

## create a binary (png) attachment
file <- tempfile(fileext = ".png")
png(file)
plot(1:10)
dev.off()
doc_attach_create(x, dbname="drinksdb", docid="asoda",
  attachment=file, attname="img.png")

## create a binary (pdf) attachment
file <- tempfile(fileext = ".pdf")
pdf(file)
plot(1:10)
dev.off()
doc_attach_create(x, dbname="drinksdb", docid="asoda",
  attachment=file, attname="plot.pdf")

# get info for an attachment (HEAD request)
doc_attach_info(x, "drinksdb", docid="asoda", attname="mtcarstable.csv")
doc_attach_info(x, "drinksdb", docid="asoda", attname="img.png")
doc_attach_info(x, "drinksdb", docid="asoda", attname="plot.pdf")

# get an attachment (GET request)
res <- doc_attach_get(x, "drinksdb", docid="asoda",
  attname="mtcarstable.csv", type = "text")
read.csv(text = res)
doc_attach_get(x, "drinksdb", docid="asoda", attname="img.png")
doc_attach_get(x, "drinksdb", docid="asoda", attname="plot.pdf")

# delete an attachment
doc_attach_delete(x, "drinksdb", docid="asoda", attname="mtcarstable.csv")
doc_attach_delete(x, "drinksdb", docid="asoda", attname="img.png")
doc_attach_delete(x, "drinksdb", docid="asoda", attname="plot.pdf")
}
}

