% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_query.R
\name{db_query}
\alias{db_query}
\title{Query a database.}
\usage{
db_query(cushion, dbname, query = NULL, selector = NULL, limit = NULL,
  skip = NULL, sort = NULL, fields = NULL, use_index = NULL,
  as = "list", ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{Database name}

\item{query}{(character) instead of using the other parameters, you can
compose one R list or json blob here}

\item{selector}{(json) - JSON object describing criteria used to select
documents. More information provided in the section on selector syntax.
See the \code{query_tutorial} in this package, and the selectors docs
\url{http://docs.couchdb.org/en/2.0.0/api/database/find.html#find-selectors}}

\item{limit}{(number) - Maximum number of results returned. Default is 25.
Optional}

\item{skip}{(number) - Skip the first 'n' results, where 'n' is the value
specified. Optional}

\item{sort}{(json) - JSON array following sort syntax. Optional.
See \url{http://docs.couchdb.org/en/2.0.0/api/database/find.html#find-sort}
For some reason, sort doesn't work often, not sure why.}

\item{fields}{(json) - JSON array specifying which fields of each object
should be returned. If it is omitted, the entire object is returned. More
information provided in the section on filtering fields. Optional
See \url{http://docs.couchdb.org/en/2.0.0/api/database/find.html#find-filter}}

\item{use_index}{(json) - Instruct a query to use a specific index.
Specified either as \code{<design_document>} or \code{["<design_document>", "<index_name>"]}. Optional}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Query a database.
}
\examples{
\dontrun{
## create a connection
(x <- Cushion$new())

file <- system.file("examples/omdb.json", package = "sofa")
strs <- readLines(file)

## create a database
if ("omdb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="omdb"))
}
db_create(x, dbname='omdb')

## add some documents
invisible(db_bulk_create(x, "omdb", strs))

## query all in one json blob
db_query(x, dbname = "omdb", query = '{
  "selector": {
    "_id": {
      "$gt": null
    }
  }
}')

## query with each parameter
db_query(x, dbname = "omdb",
  selector = list(`_id` = list(`$gt` = NULL)))

db_query(x, dbname = "omdb",
  selector = list(`_id` = list(`$gt` = NULL)), limit = 3)

# fields
## single field works
db_query(x, dbname = "omdb",
  selector = list(`_id` = list(`$gt` = NULL)), limit = 3,
  fields = c('_id', 'Actors', 'imdbRating'))

## as well as many fields
db_query(x, dbname = "omdb",
  selector = list(`_id` = list(`$gt` = NULL)), limit = 3,
  fields = '_id')

## other queries
db_query(x, dbname = "omdb",
  selector = list(Year = list(`$gt` = "2013")))

db_query(x, dbname = "omdb", selector = list(Rated = "R"))

db_query(x, dbname = "omdb",
  selector = list(Rated = "PG", Language = "English"))

db_query(x, dbname = "omdb", selector = list(
  `$or` = list(
    list(Director = "Jon Favreau"),
    list(Director = "Spike Lee")
  )
), fields = c("_id", "Director"))

## when selector vars are of same name, use a JSON string
## b/c R doesn't let you have a list with same name slots
db_query(x, dbname = "omdb", query = '{
  "selector": {
    "Year": {"$gte": "1990"},
    "Year": {"$lte": "2000"},
    "$not": {"Year": "1998"}
  },
  "fields": ["_id", "Year"]
}')

## regex
db_query(x, dbname = "omdb", selector = list(
  Director = list(`$regex` = "^R")
), fields = c("_id", "Director"))

}
}
