% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDA_coecoclass.R
\name{get_SDA_coecoclass}
\alias{get_SDA_coecoclass}
\title{Get mapunit ecological sites from Soil Data Access}
\usage{
get_SDA_coecoclass(
  method = "None",
  areasymbols = NULL,
  mukeys = NULL,
  query_string = FALSE,
  ecoclassref = "Ecological Site Description Database",
  not_rated_value = "Not assigned",
  miscellaneous_areas = TRUE
)
}
\arguments{
\item{method}{aggregation method. One of: "Dominant Component", "Dominant Condition", "None". If "None" is selected one row will be returned per component, otherwise one row will be returned per map unit.}

\item{areasymbols}{vector of soil survey area symbols}

\item{mukeys}{vector of map unit keys}

\item{query_string}{Default: \code{FALSE}; if \code{TRUE} return a character string containing query that would be sent to SDA via \code{SDA_query}}

\item{ecoclassref}{Default: \code{"Ecological Site Description Database"}. If \code{NULL} no constraint on \code{ecoclassref} is used in the query.}

\item{not_rated_value}{Default: \code{"Not assigned"}}

\item{miscellaneous_areas}{Include miscellaneous areas (non-soil components)?}
}
\description{
Get mapunit ecological sites from Soil Data Access
}
\details{
When \code{method="Dominant Condition"} an additional field \code{ecoclasspct_r} is returned in the result with the sum of \code{comppct_r} that have the dominant condition \code{ecoclassid}. The component with the greatest \code{comppct_r} is returned for the \code{component} and \code{coecosite} level information.

Note that if there are multiple \code{coecoclasskey} per \code{ecoclassid} there may be more than one record per component.
}
