% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSSURGO.R
\name{createSSURGO}
\alias{createSSURGO}
\title{Create a database from SSURGO Exports}
\usage{
createSSURGO(
  filename,
  exdir,
  conn = DBI::dbConnect(DBI::dbDriver("SQLite"), filename, loadable.extensions = TRUE),
  pattern = NULL,
  include_spatial = TRUE,
  overwrite = FALSE,
  header = FALSE,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{filename}{Output file name (e.g. \code{'db.sqlite'} or \code{'db.gpkg'}). Only used when \code{con} is not specified by the user.}

\item{exdir}{Path containing containing input SSURGO spatial (.shp) and tabular (.txt) files, downloaded and extracted by \code{downloadSSURGO()} or similar.}

\item{conn}{A \emph{DBIConnection} object. Default is a \code{SQLiteConnection} used for writing .sqlite or .gpkg files. Alternate options are any DBI connection types. When \code{include_spatial=TRUE}, the sf package is used to write spatial data to the database.}

\item{pattern}{Character. Optional regular expression to use to filter subdirectories of \code{exdir}. Default: \code{NULL} will search all subdirectories for SSURGO export files.}

\item{include_spatial}{Logical. Include spatial data layers in database? Default: \code{TRUE}.}

\item{overwrite}{Logical. Overwrite existing layers? Default \code{FALSE} will append to existing tables/layers.}

\item{header}{Logical. Passed to \code{read.delim()} for reading pipe-delimited (\code{|}) text files containing tabular data.}

\item{quiet}{Logical. Suppress messages and other output from database read/write operations?}

\item{...}{Additional arguments passed to \code{write_sf()} for writing spatial layers.}
}
\value{
Character. Vector of layer/table names in \code{filename}.
}
\description{
The following database types are tested and fully supported:
\itemize{
\item SQLite or Geopackage
\item DuckDB
\item Postgres or PostGIS
}

In theory any other DBI-compatible data source can be used for output. See \code{conn} argument. If you encounter issues using specific DBI connection types, please report in the soilDB issue tracker.
}
\examples{
\dontrun{
 downloadSSURGO("areasymbol IN ('CA067', 'CA077', 'CA632')", destdir = "SSURGO_test")
 createSSURGO("test.gpkg", "SSURGO_test")
}
}
\seealso{
\code{\link[=downloadSSURGO]{downloadSSURGO()}}
}
