% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/files.lib.R
\name{readPhen}
\alias{readPhen}
\title{Read plain-text table files phen and ped}
\usage{
readPhen(phen.file, sep.phen = ",", ped.file, sep.ped = ",",
  header = TRUE, stringsAsFactors = FALSE, id.unique = TRUE, sex.optional)
}
\arguments{
\item{phen.file}{A character, path to phen file.}

\item{sep.phen}{A character, the field separator in phen file.
The default value is \code{","}.}

\item{ped.file}{(optional) A character, path to ped file.}

\item{sep.ped}{A character, the field separator in ped file.
The default value is \code{","}.}

\item{header}{Logical, indicating whether the file contains
the names of the variables as its first line.
The default value is TRUE.}

\item{stringsAsFactors}{logical, indicating whether character vectors to be converted to factors.
The default value is FALSE.}

\item{id.unique}{logical, indicating whether the IDs of individuals must be unique.
The default value is TRUE.}

\item{sex.optional}{logical, indicating whether the SEX field must be presented.
The default value is TRUE if \code{ped.file} is specified,
and it is FALSE otherwise.}
}
\value{
A data frame of phenotype data merged from two phen and ped files (merged by ID filed).
}
\description{
The function reads the phenotype and pedigree data in SOLAR format,
i.e. plain-text tables.
}

