#    SOMnn topology-based classifier
#    Copyright (C) 2017  Andreas Dominik
#                        THM University of Applied Sciences
#                        Gießen, Germany
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#' Topological k-NN Classifier Based on Self-Organising Maps
#' 
#' The package \code{som.nn} provides tools to train self-organising maps
#' and predict class memberships by means of a k-NN-like classifier.
#' 
#' The functions \code{\link{som.nn.train}} and \code{\link{som.nn.continue}} are used 
#' train and re-train self-organising maps. The training can be performed with functions 
#' of the packages 
#' \pkg{kohonen}, \pkg{som}, \pkg{class} or with pure-R-implementations with
#' distance function \code{bubble} (kernel \code{internal}) or
#' \code{gaussian} (kernel \code{gaussian}). 
#' (Remark: The pure-R-impelementations actually are faster as the external calls to
#' C implementations in the above-mentioned packages!).
#' 
#' In contrast to a normal som training, class lables are required for all
#' training samples. These class lables are used to assign classes to the
#' codebook vectors (i.e. the neurons of the map) after the training and build 
#' the set of reference
#' vectors. This reference is used for nearest-neigbour classification.
#' 
#' The nearest neighbour classifier is implemented as predict method. 
#' It is controlled by the following parameters:
#' \itemize{
#'    \item \code{dist.fun}: the distance function to weight the distance of reference
#'          vectors and the sample to be predicted.
#'    \item \code{max.dist}: the maximum distance to be considered.
#' }
#' Some distance functions are provided in the package (linear, bubble, inverse 
#' and tricubic) but any custom function scan be defined as well.
#' 
#' The prediction differs significantly from a standard nearest-neighbour classifier, because 
#' the neighbourhood is not defined by the distance between reference vectors and 
#' unknown sample vector. Instead the neighbourhood of the neurons on the 
#' self-oranising map is used.
#' 
#' Because the som have been generated by an unsupervised training, the classifier is 
#' robust against overtraining. 
#' 
#' In addition the abstract model can be visualised as 2-dimensional map, using
#' the plot method.
#' 


"_PACKAGE"