% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{print.tree.applyChanges}
\alias{print.tree.applyChanges}
\title{Pretty printing for part of the result of \code{\link{applyChanges}}.}
\usage{
\method{print}{tree.applyChanges}(x, ...)
}
\arguments{
\item{x}{[tree.applyChanges] The \code{tree} element in the output of \code{\link{applyChanges}}.}

\item{...}{Unused; only for consistency with \code{\link{print}}.}
}
\value{
[tree.applyChanges] The same object that was given as \code{x}.
}
\description{
Pretty printing for part of the result of \code{\link{applyChanges}}.
}
\details{
One of the elements in the output of \code{\link{applyChanges}} is a tree. It is represented as a nested list, potentially a very deeply nested and a very long list which would have been all but impossible to digest for a human. This function prints it as a structure that more resembles a tree, very similar to the output of \code{\link{str}}.
}
\examples{
# prepare sample transcription
trans <- loadSampleDataset ("trans-common")
# define sound changes
ab <- soundchange (function(x,meta) c("a","b"), "change 1", trans)
ab2c <- soundchange ("[ab] > c", "change 2", trans)
# and apply them
applyChanges (c("a","b","c"), list(ab,ab2c))$tree
}
\seealso{
\code{\link{applyChanges}}, \code{\link{print.list.applyChanges}}
}
