% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formants.R
\name{getBandwidth}
\alias{getBandwidth}
\title{Get bandwidth}
\usage{
getBandwidth(f)
}
\arguments{
\item{f}{a vector of formant frequencies, Hz}
}
\description{
Internal soundgen function.
}
\details{
Calculates formant bandwidth as a function of formant frequencies using a
modified version of TMF-63 formula. Namely, above 500 Hz it follows the
original formula from Tappert, Martony, and Fant (TMF)-1963, and below 500 Hz
it applies a correction to allow for energy losses at low frequencies. See
Khodai-Joopari & Clermont (2002), "Comparison of formulae for estimating
formant bandwidths".
}
\examples{
f = 1:5000
plot(f, soundgen:::getBandwidth(f), type = 'l',
  xlab = 'Formant frequency, Hz', ylab = 'Estimated bandwidth, Hz')
}
\keyword{internal}
