% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subharmonics.R
\name{getVocalFry}
\alias{getVocalFry}
\title{Subharmonics}
\usage{
getVocalFry(rolloff, pitch_per_gc, subFreq = 100, subDep = 100,
  dynamicRange = 80, shortestEpoch = 300)
}
\arguments{
\item{rolloff}{matrix of original amplitudes of each harmonic in f0 stack
returned by \code{\link{getRolloff}} (columns=time, rows=frequency bins)}

\item{pitch_per_gc}{vector of the same length as ncol(rolloff)): f0 in Hz,
one value per glottal cycle}

\item{subFreq}{target frequency of subharmonics, Hz (lower than f0, adjusted
dynamically so f0 is always a multiple of subFreq) (anchor format)}

\item{subDep}{the width of subharmonic band, Hz. Regulates how quickly the
strength of subharmonics fades as they move away from harmonics in f0 stack
(anchor format)}

\item{dynamicRange}{dynamic range, dB. Harmonics and noise more than
dynamicRange under maximum amplitude are discarded to save computational
resources}

\item{shortestEpoch}{minimum duration of each epoch with unchanging
subharmonics regime, in ms}
}
\value{
Returns a list consisting of a list of rolloff matrices (one matrix
  per epoch) and a dataframe of epochs.
}
\description{
Internal soundgen function.
}
\details{
Adds subharmonics to the main (f0) harmonic stack, forming sidebands.
}
\examples{
pitch_per_gc = c(400, 500, 600, 700)
rolloff = getRolloff(pitch_per_gc, rolloff = -30)
# one epoch, two subharmonics
rolloff_subh = soundgen:::getVocalFry(rolloff, pitch_per_gc,
  subFreq = 200, subDep = 150, shortestEpoch = 100)
# three epochs with 2/3/4 subharmonics
rolloff_subh = soundgen:::getVocalFry(rolloff, pitch_per_gc,
  subFreq = 200, subDep = 150, shortestEpoch = 0)
}
\keyword{internal}
