% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{osc}
\alias{osc}
\title{Oscillogram}
\usage{
osc(
  x,
  dynamicRange = 80,
  dB = FALSE,
  maxAmpl = NULL,
  samplingRate = NULL,
  returnWave = FALSE,
  plot = TRUE,
  xlab = NULL,
  ylab = NULL,
  ylim = NULL,
  bty = "n",
  midline = TRUE,
  maxPoints = 10000,
  ...
)
}
\arguments{
\item{x}{path to a .wav file or a vector of amplitudes with specified
samplingRate}

\item{dynamicRange}{dynamic range of the oscillogram, dB}

\item{dB}{if TRUE, plots on a dB instead of linear scale}

\item{maxAmpl}{the maximum theoretically possible value indicating on which
scale the sound is coded: 1 if the range is -1 to +1, 2^15 for 16-bit wav
files, etc}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector, rather than a .wav file)}

\item{returnWave}{if TRUE, returns a log-transformed waveform as a numeric vector}

\item{plot}{if TRUE, plots the oscillogram}

\item{xlab, ylab}{axis labels}

\item{ylim}{override default amplitude scale for non-centered sounds}

\item{bty}{box type (see `?par`)}

\item{midline}{if TRUE, draws a line at 0 dB}

\item{maxPoints}{the maximum number of points to plot (speeds up the plotting
of long audio files, but beware of antialiasing)}

\item{...}{Other graphical parameters passed on to `plot()`}
}
\value{
If \code{returnWave = TRUE}, returns the input waveform on the
  original or dB scale: a vector with range from `-dynamicRange` to
  `dynamicRange`.
}
\description{
Plots the oscillogram (waveform) of a sound on a linear or logarithmic scale
(in dB). To get a dB scale, centers and normalizes the sound, then takes a
logarithm of the positive part and a flipped negative part, which is
analogous to "Waveform (dB)" view in Audacity. For more plotting options,
check \code{\link[seewave]{oscillo}}.
}
\examples{
sound = sin(1:2000/10) *
        getSmoothContour(anchors = c(1, .01, .5), len = 2000)

# Oscillogram on a linear scale without bells and whistles, just base R
plot(sound, type = 'l')

# Oscillogram options with soundgen
osc(sound)             # linear
osc(sound, dB = TRUE)  # dB

# For numeric vectors, indicate max amplitude
osc(sound, maxAmpl = 100, dB = TRUE)

# Embellish and customize the plot
o = osc(sound, dB = TRUE, samplingRate = 1000, midline = FALSE,
        main = 'My waveform', col = 'blue', returnWave = TRUE)
abline(h = -80, col = 'orange', lty = 3)
o[1:10]  # the waveform in dB

\dontrun{
# audio file
data(sheep, package = 'seewave')
osc(sheep@left, samplingRate = sheep@samp.rate, dB = TRUE)

# for long files, reduce the resolution to plot quickly (careful: if the
# resolution is too low, antialiasing may cause artifacts)
osc(sheep@left, samplingRate = sheep@samp.rate, dB = TRUE, maxPoints = 2500)
osc(sound, samplingRate = 5000, maxPoints = 100)

# files several minutes long can be plotted in under a second
osc('~/Downloads/speechEx.wav', maxPoints = 20000)
}
}
