% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{HzToERB}
\alias{HzToERB}
\title{Convert Hz to ERB rate}
\usage{
HzToERB(h, method = c("linear", "quadratic")[1])
}
\arguments{
\item{h}{vector or matrix of frequencies (Hz)}

\item{method}{approximation to use}
}
\description{
Converts from Hz to the number of Equivalent Rectangular Bandwidths (ERBs)
below input frequency. See https://www2.ling.su.se/staff/hartmut/bark.htm and
https://en.wikipedia.org/wiki/Equivalent_rectangular_bandwidth
}
\examples{
HzToERB(c(-20, 20, 100, 440, 1000, NA))

f = 20:20000
erb_lin = HzToERB(f, 'linear')
erb_quadratic = HzToERB(f, 'quadratic')
plot(f, erb_lin, log = 'x', type = 'l')
points(f, erb_quadratic, col = 'blue', type = 'l')

# compare with the bark scale:
barks = tuneR::hz2bark(f)
points(f, barks / max(barks) * max(erb_lin),
  col = 'red', type = 'l', lty = 2)
}
\seealso{
\code{\link{ERBToHz}} \code{\link{HzToSemitones}}
  \code{\link{HzToNotes}}
}
