% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitchTrackers.R
\name{getPitchSpec}
\alias{getPitchSpec}
\title{BaNa pitch tracker}
\usage{
getPitchSpec(
  frame,
  bin,
  freqs,
  specMethod = c("commonFactor", "BaNa")[1],
  specRatios,
  specSmooth,
  specThres,
  specMerge,
  specPeak,
  specHNRslope,
  HNR = NULL,
  specSinglePeakCert,
  pitchFloor,
  pitchCeiling,
  nCands
)
}
\arguments{
\item{frame}{the abs spectrum of a frame, as returned by
\code{\link[stats]{fft}}}

\item{bin}{the width of spectral bin in \code{frame}, Hz}

\item{freqs}{frequency per bin of spectrogram}

\item{specMethod}{"commonFactor" = highest common factor of putative
harmonics, "BaNa" = ratio of putative harmonics}

\item{specRatios}{for method = "commonFactor", the number of harmonics AND
integer fractions to consider}

\item{specSmooth}{the width of window for detecting peaks in the spectrum, Hz}

\item{specThres}{voicing threshold (unitless, ~0 to 1)}

\item{specMerge}{pitch candidates within \code{specMerge} semitones are
merged with boosted certainty}

\item{specPeak, specHNRslope}{when looking for putative harmonics in
the spectrum, the threshold for peak detection is calculated as
\code{specPeak * (1 - HNR * specHNRslope)}}

\item{HNR}{harmonics-to-noise ratio returned by \code{\link{getPitchAutocor}}}

\item{specSinglePeakCert}{(0 to 1) if f0 is calculated based on a single
harmonic ratio (as opposed to several ratios converging on the same
candidate), its certainty is taken to be \code{specSinglePeakCert}}

\item{pitchFloor, pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{nCands}{number of pitch candidates pre frame (specMethod =
"commonFactor" always returns a single candidate)}
}
\value{
Returns either NULL or a dataframe of pitch candidates.
}
\description{
Internal soundgen function.
}
\details{
Attempts to find F0 of a frame by detecting several putative harmonics and
either finding their highest common factor (specMethod = "commonFactor") or
comparing their ratios (specMethod = "BaNa"). For the highest common factor
method, see Howard & Angus (2017) "Acoustics and psychoacoustics" (section
3.2.1). For BaNa, see Ba et al. (2012) "BaNa: A hybrid approach for noise
resilient pitch detection." Statistical Signal Processing Workshop (SSP),
2012 IEEE.
}
\keyword{internal}
