% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_functions.R
\name{lixelize_lines.mc}
\alias{lixelize_lines.mc}
\title{Cut lines into lixels (multicore)}
\usage{
lixelize_lines.mc(
  lines,
  lx_length,
  mindist = NULL,
  verbose = TRUE,
  chunk_size = 100
)
}
\arguments{
\item{lines}{The SpatialLinesDataframe to modify}

\item{lx_length}{The length of a lixel}

\item{mindist}{The minimum length of a lixel. After cut, if the length of the
final lixel is shorter than the minimum distance, then it is added to the
previous lixel. If NULL, then mindist = maxdist/10}

\item{verbose}{A Boolean indicating if a progress bar must be displayed}

\item{chunk_size}{The size of a chunk used for multiprocessing. Default is
100.}
}
\value{
An object of class SpatialLinesDataFrame (package sp)
}
\description{
Cut a SpatialLines object into lixels with a specified minimal
 distance may fail if the lines geometries are self intersecting with
 multicore support.
}
\examples{
\dontrun{
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
mtl_network <- rgdal::readOGR(networkgpkg,layer="mtl_network", verbose=FALSE)
future::plan(future::multisession(workers=2))
lixels <- lixelize_lines.mc(mtl_network,150,50)
## make sure any open connections are closed afterward
if (!inherits(future::plan(), "sequential")){
future::plan(future::sequential)
}
}
}
