% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nkde_execution_functions_sf.R
\name{adaptive_bw.mc}
\alias{adaptive_bw.mc}
\title{Adaptive bandwidth (multicore)}
\usage{
adaptive_bw.mc(
  grid,
  events,
  lines,
  bw,
  trim_bw,
  method,
  kernel_name,
  max_depth,
  tol,
  digits,
  sparse,
  verbose
)
}
\arguments{
\item{grid}{A spatial grid to split the data within}

\item{events}{A feature collection of points representing the events}

\item{lines}{A feature collection of linestrings representing the network}

\item{bw}{The fixed kernel bandwidth (can also be a vector, the value returned will be a matrix in that case)}

\item{trim_bw}{The maximum size of local bandwidths (can also be a vector, must match bw)}

\item{method}{The method to use when calculating the NKDE}

\item{kernel_name}{The name of the kernel to use}

\item{max_depth}{The maximum recursion depth}

\item{tol}{A float indicating the spatial tolerance when snapping events on
lines}

\item{digits}{The number of digits to keep}

\item{sparse}{A Boolean indicating if sparse matrix should be used}

\item{verbose}{A Boolean indicating if update messages should be printed}
}
\value{
A vector with the local bandwidths
}
\description{
Function to calculate Adaptive bandwidths according to
Abramson’s smoothing regimen with multicore support
}
\examples{
#This is an internal function, no example provided
}
\keyword{internal}
