\name{setPara}
\alias{setPara}
\title{Set specific parameters for metaObjects generated by sparkTable_Config()}
\description{
  with setPara() it is possible to change specific parameters for meta objects that have been generated by sparkTable_Config().
}
\usage{
setPara(metaObj, para, val, col=NULL)
}
\arguments{
  \item{metaObj }{an object of class sparkTable.}
  \item{para }{the parameter to be set}
  \item{val }{the value of the parameter to be set}
  \item{col }{optionally, the column index of the object in which the parameter should be changed.}
}
\author{Bernhard Meindl, Alexander Kowarik, Statistics Austria }
		
\seealso{\code{\link{print.sparkTable}}, \code{\link{setPara}}, \code{\link{sparkTable_Config}}, \code{\link{spark}}, 
		\code{\link{spark_init}}, \code{\link{sparkHTML}},, \code{\link{sparkEPS}}}
				
\examples{
data(population)
metaObj <- sparkTable_Config(
		df=pop, 
		groups=as.character(unique(pop[,2])), 
		groupVar="variable", 
		vars=c("value"), 
		typeNumeric=list(c("min", "max")), 
		typePlot=c("line"),
		output="eps")

# set top_padding and bottom_padding for all graphics to zero		
metaObj$metaData <- setPara(metaObj$metaData, "top_padding", 0)
metaObj$metaData <- setPara(metaObj$metaData, "bottom_padding", 0)

# do something with metaObj, print for example.
}
