/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class ArgumentUtils {
    public static String[] EMPTY_STRING_ARRAY = new String[0];

    public static <T> void notEmpty(String argDescription, T ... args) {
        if (args == null) {
            throw new IllegalArgumentException(argDescription + " must not be null");
        }
        if (args.length == 0) {
            throw new IllegalArgumentException(argDescription + " must not be empty");
        }
    }

    public static <T> void noNulls(String argDescription, T ... args) {
        ArgumentUtils.notEmpty(argDescription, args);
        for (T arg : args) {
            if (arg != null) continue;
            if (args.length > 0) {
                throw new IllegalArgumentException(argDescription + " must not contain nulls");
            }
            throw new IllegalArgumentException(argDescription + " must not be null");
        }
    }

    public static <T> void fill(Collection<T> c, T ... elems) {
        for (T e : elems) {
            c.add(e);
        }
    }

    public static int indexOf(Object[] array, Object element) {
        if (array == null) {
            throw new NullPointerException("Null array");
        }
        if (element == null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            int i;
            if (element instanceof String && array instanceof String[]) {
                for (i = 0; i < array.length; ++i) {
                    String e = String.valueOf(array[i]);
                    if (!element.toString().equalsIgnoreCase(e)) continue;
                    return i;
                }
            }
            for (i = 0; i < array.length; ++i) {
                if (!element.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static Object[] findMissingElements(Object[] array, Collection<?> elements) {
        return ArgumentUtils.findMissingElements(array, elements.toArray());
    }

    public static Object[] findMissingElements(Object[] array, Object[] elements) {
        ArrayList<Object> out = new ArrayList<Object>();
        for (Object element : elements) {
            if (ArgumentUtils.indexOf(array, element) != -1) continue;
            out.add(element);
        }
        return out.toArray();
    }

    public static String[] normalize(String[] strings) {
        String[] out = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            out[i] = ArgumentUtils.normalize(strings[i]);
        }
        return out;
    }

    public static String normalize(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().toLowerCase();
    }

    public static void normalize(Collection<String> strings) {
        HashSet<String> normalized = new HashSet<String>(strings.size());
        for (String string : strings) {
            normalized.add(string.trim().toLowerCase());
        }
        strings.clear();
        strings.addAll(normalized);
    }
}

