% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_hashing_tf.R
\name{ft_hashing_tf}
\alias{ft_hashing_tf}
\title{Feature Transformation -- HashingTF (Transformer)}
\usage{
ft_hashing_tf(
  x,
  input_col = NULL,
  output_col = NULL,
  binary = FALSE,
  num_features = 2^18,
  uid = random_string("hashing_tf_"),
  ...
)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{input_col}{The name of the input column.}

\item{output_col}{The name of the output column.}

\item{binary}{Binary toggle to control term frequency counts.
If true, all non-zero counts are set to 1. This is useful for discrete
probabilistic models that model binary events rather than integer
counts. (default = \code{FALSE})}

\item{num_features}{Number of features. Should be greater than 0. (default = \code{2^18})}

\item{uid}{A character string used to uniquely identify the feature transformer.}

\item{...}{Optional arguments; currently unused.}
}
\value{
The object returned depends on the class of \code{x}. If it is a
\code{spark_connection}, the function returns a \code{ml_estimator} or a
\code{ml_estimator} object. If it is a \code{ml_pipeline}, it will return
a pipeline with the transformer or estimator appended to it. If a
\code{tbl_spark}, it will return a \code{tbl_spark} with the transformation
 applied to it.
}
\description{
Maps a sequence of terms to their term frequencies using the hashing trick.
}
\seealso{
Other feature transformers: 
\code{\link{ft_binarizer}()},
\code{\link{ft_bucketizer}()},
\code{\link{ft_chisq_selector}()},
\code{\link{ft_count_vectorizer}()},
\code{\link{ft_dct}()},
\code{\link{ft_elementwise_product}()},
\code{\link{ft_feature_hasher}()},
\code{\link{ft_idf}()},
\code{\link{ft_imputer}()},
\code{\link{ft_index_to_string}()},
\code{\link{ft_interaction}()},
\code{\link{ft_lsh}},
\code{\link{ft_max_abs_scaler}()},
\code{\link{ft_min_max_scaler}()},
\code{\link{ft_ngram}()},
\code{\link{ft_normalizer}()},
\code{\link{ft_one_hot_encoder_estimator}()},
\code{\link{ft_one_hot_encoder}()},
\code{\link{ft_pca}()},
\code{\link{ft_polynomial_expansion}()},
\code{\link{ft_quantile_discretizer}()},
\code{\link{ft_r_formula}()},
\code{\link{ft_regex_tokenizer}()},
\code{\link{ft_robust_scaler}()},
\code{\link{ft_sql_transformer}()},
\code{\link{ft_standard_scaler}()},
\code{\link{ft_stop_words_remover}()},
\code{\link{ft_string_indexer}()},
\code{\link{ft_tokenizer}()},
\code{\link{ft_vector_assembler}()},
\code{\link{ft_vector_indexer}()},
\code{\link{ft_vector_slicer}()},
\code{\link{ft_word2vec}()}
}
\concept{feature transformers}
