# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Vertex coloring of a sparse undirected graph
#' @description Generate proper vertex coloring of a sparse undirected graph.
#' @param pntr,idx row pointers and column indices of the adjacency matrix, in compressed column-oriented format. Must use zero-based indexing.
#' @param nvars Number of vertices.
#' @return An integer vector of length nvars, where each element represents the color of the corresponding vertex. Indices are zero-based.
#' @details  For internal use.  You should not have to call this function directly.
get_colors <- function(pntr, idx, nvars) {
    .Call(`_sparseHessianFD_get_colors`, pntr, idx, nvars)
}

#' @title Estimate sparse Hessian
#' @description Estimate Hessian using triangular subsitution algorithm
#' @param Y Matrix of finite differences of gradients
#' @param colors Vector of length nvars that identifies color of each variable
#' @param jCol,ipntr Column indices and row pointers for non-zero elements of lower triangle of Hessian (row-oriented compressed format).
#' @param delta Perturbation factor used to compute finite differences of gradients.
#' @param nvars Dimension of Hessian (number of variables)
#' @param nnz Number of non-zero elements in the lower triangle of the Hessian.
#' @return A sparse Hessian of class dgCMatrix.
#' @details For internal use.  You should not have to call this function directly.
subst <- function(Y, colors, jCol, ipntr, delta, nvars, nnz) {
    .Call(`_sparseHessianFD_subst`, Y, colors, jCol, ipntr, delta, nvars, nnz)
}

